/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.jgroups;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsFilter
extends ReceiverAdapter
implements ClusterBroadcastFilter {
    private static final Logger logger = LoggerFactory.getLogger(JGroupsFilter.class);
    private JChannel jchannel;
    private String clusterName = "cluster-jgroups";
    private Broadcaster bc;
    private final ConcurrentLinkedQueue<String> receivedMessages = new ConcurrentLinkedQueue();

    public JGroupsFilter() {
        this(null);
    }

    public JGroupsFilter(Broadcaster bc) {
        this(bc, "atmosphere-framework");
    }

    public JGroupsFilter(Broadcaster bc, String containerName) {
        this(bc, containerName, "cluster-atmosphere");
    }

    public JGroupsFilter(Broadcaster bc, String containerName, String clusterName) {
        this.bc = bc;
        this.clusterName = clusterName;
    }

    public void setUri(String clusterName) {
        this.clusterName = clusterName;
    }

    public void init() {
        try {
            logger.info("Starting Atmosphere JGroups Clustering support");
            this.jchannel = new JChannel();
            this.jchannel.setReceiver((Receiver)this);
            this.jchannel.connect(this.clusterName);
        }
        catch (Throwable t) {
            logger.warn("failed to connect to cluser", t);
        }
    }

    public void destroy() {
        this.jchannel.shutdown();
    }

    public void receive(Message message) {
        String msg = (String)message.getObject();
        if (message.getSrc() != this.jchannel.getLocalAddress() && msg != null) {
            this.receivedMessages.offer(msg);
            if (this.bc != null) {
                this.bc.broadcast((Object)msg);
            }
        }
    }

    public BroadcastFilter.BroadcastAction filter(Object originalMessage, Object o) {
        if (o instanceof String) {
            String message = (String)o;
            if (!this.receivedMessages.remove(message)) {
                try {
                    this.jchannel.send(new Message(null, null, (Serializable)((Object)message)));
                }
                catch (ChannelException e) {
                    logger.warn("failed to send message", (Throwable)e);
                }
            }
            return new BroadcastFilter.BroadcastAction((Object)message);
        }
        return new BroadcastFilter.BroadcastAction(o);
    }

    public Broadcaster getBroadcaster() {
        return this.bc;
    }

    public void setBroadcaster(Broadcaster bc) {
        this.bc = bc;
    }
}

