/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.jgroups;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.plugin.jgroups.JGroupsBroadcaster;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsFilter
extends ReceiverAdapter
implements ClusterBroadcastFilter {
    private static final Logger logger = LoggerFactory.getLogger(JGroupsFilter.class);
    private JChannel jchannel;
    private Broadcaster bc;
    private final ConcurrentLinkedQueue<Object> receivedMessages = new ConcurrentLinkedQueue();

    public JGroupsFilter() {
        this(BroadcasterFactory.getDefault().get(DefaultBroadcaster.class, (Object)"JGroupFilter"));
    }

    public JGroupsFilter(Broadcaster bc) {
        this.bc = bc;
    }

    public void init() {
        try {
            logger.info("Starting Atmosphere JGroups Clustering support with group name {}", (Object)this.bc.getID());
            this.jchannel = new JChannel();
            this.jchannel.setReceiver((Receiver)this);
            this.jchannel.connect(this.bc.getID());
        }
        catch (Throwable t) {
            logger.warn("failed to connect to cluser", t);
        }
    }

    public void destroy() {
        this.jchannel.shutdown();
    }

    public void receive(Message message) {
        Object msg = message.getObject();
        if (message.getSrc() != this.jchannel.getLocalAddress() && msg != null && msg != null && JGroupsBroadcaster.BroadcastMessage.class.isAssignableFrom(msg.getClass())) {
            this.receivedMessages.offer(msg);
            JGroupsBroadcaster.BroadcastMessage b = (JGroupsBroadcaster.BroadcastMessage)JGroupsBroadcaster.BroadcastMessage.class.cast(msg);
            if (b.getTopicId().equalsIgnoreCase(this.bc.getID())) {
                this.bc.broadcast(b.getMessage());
            }
        }
    }

    public BroadcastFilter.BroadcastAction filter(Object originalMessage, Object message) {
        if (!this.receivedMessages.remove(message)) {
            try {
                this.jchannel.send(new Message(null, null, (Serializable)new JGroupsBroadcaster.BroadcastMessage(this.bc.getID(), message)));
            }
            catch (ChannelException e) {
                logger.warn("failed to send message", (Throwable)e);
            }
        }
        return new BroadcastFilter.BroadcastAction(message);
    }

    public Broadcaster getBroadcaster() {
        return this.bc;
    }

    public void setUri(String name) {
        this.bc.setID(name);
    }

    public void setBroadcaster(Broadcaster bc) {
        this.bc = bc;
    }
}

