/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.jgroups;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.plugin.jgroups.BroadcastMessage;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsChannel
extends ReceiverAdapter {
    private static final Logger logger = LoggerFactory.getLogger(JGroupsChannel.class);
    private final JChannel jchannel;
    private final String clusterName;
    private final String id;
    private final Map<String, Broadcaster> broadcasters = new HashMap<String, Broadcaster>();
    private final ConcurrentLinkedQueue<Object> receivedMessages = new ConcurrentLinkedQueue();

    public JGroupsChannel(JChannel jchannel, String clusterName) {
        if (jchannel.isConnected()) {
            throw new IllegalArgumentException("JChannel already connected");
        }
        this.jchannel = jchannel;
        this.clusterName = clusterName;
        this.id = UUID.randomUUID().toString() + "_" + System.currentTimeMillis();
    }

    public void init() throws Exception {
        logger.info("Starting Atmosphere JGroups Clustering support with group name {}", (Object)this.clusterName);
        try {
            this.jchannel.setReceiver((Receiver)this);
            this.jchannel.connect(this.clusterName);
        }
        catch (Exception e) {
            logger.warn("Failed to connect to cluster: " + this.clusterName, (Throwable)e);
            throw e;
        }
    }

    public void destroy() {
        this.jchannel.shutdown();
        this.receivedMessages.clear();
        this.broadcasters.clear();
    }

    public void receive(Message jgroupMessage) {
        Object payload = jgroupMessage.getObject();
        if (payload == null) {
            return;
        }
        if (BroadcastMessage.class.isAssignableFrom(payload.getClass())) {
            BroadcastMessage broadcastMsg = (BroadcastMessage)BroadcastMessage.class.cast(payload);
            if (this.id.equalsIgnoreCase(broadcastMsg.getClusterChannelId())) {
                return;
            }
            Object origMessage = broadcastMsg.getMessage();
            this.receivedMessages.offer(origMessage);
            String topicId = broadcastMsg.getTopic();
            if (this.broadcasters.containsKey(topicId)) {
                Broadcaster bc = this.broadcasters.get(topicId);
                try {
                    bc.broadcast(origMessage).get();
                }
                catch (Exception ex) {
                    logger.error("Failed to broadcast message received over the JGroups cluster " + this.clusterName, (Throwable)ex);
                }
            }
        }
    }

    public void send(String topic, Object message) {
        if (this.jchannel.isConnected() && !this.receivedMessages.remove(message)) {
            try {
                BroadcastMessage broadcastMsg = new BroadcastMessage(this.id, topic, message);
                Message jgroupMsg = new Message(null, null, (Serializable)broadcastMsg);
                this.jchannel.send(jgroupMsg);
            }
            catch (ChannelException e) {
                logger.warn("Failed to send message {}", message, (Object)e);
            }
        }
    }

    public void addBroadcaster(Broadcaster broadcaster) {
        this.broadcasters.put(broadcaster.getID(), broadcaster);
    }

    public void removeBroadcaster(Broadcaster broadcaster) {
        this.broadcasters.remove(broadcaster.getID());
    }
}

