/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.jgroups;

import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.atmosphere.plugin.jgroups.JGroupsChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsFilter
implements ClusterBroadcastFilter {
    private static final Logger logger = LoggerFactory.getLogger(JGroupsFilter.class);
    private JGroupsChannel jchannel;
    private Broadcaster bc;

    public JGroupsFilter(JGroupsChannel jchannel) {
        this.jchannel = jchannel;
    }

    public JGroupsFilter(JGroupsChannel jchannel, Broadcaster bc) {
        this(jchannel);
        this.setBroadcaster(bc);
    }

    public void destroy() {
        this.jchannel.removeBroadcaster(this.bc);
        this.bc = null;
    }

    public void init() {
    }

    public BroadcastFilter.BroadcastAction filter(Object originalMessage, Object message) {
        if (this.bc != null) {
            this.jchannel.send(this.bc.getID(), message);
        }
        return new BroadcastFilter.BroadcastAction(message);
    }

    public Broadcaster getBroadcaster() {
        return this.bc;
    }

    public void setBroadcaster(Broadcaster bc) {
        this.bc = bc;
        if (bc != null) {
            this.jchannel.addBroadcaster(bc);
        }
    }

    public void setUri(String clusterUri) {
    }
}

