/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.jgroups;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.util.AbstractBroadcasterProxy;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsBroadcaster
extends AbstractBroadcasterProxy {
    private static final Logger logger = LoggerFactory.getLogger(JGroupsBroadcaster.class);
    private JChannel jchannel;
    private final CountDownLatch ready = new CountDownLatch(1);

    public Broadcaster initialize(String id, AtmosphereConfig config) {
        return super.initialize(id, null, config);
    }

    public void incomingBroadcast() {
        try {
            logger.info("Starting Atmosphere JGroups Clustering support with group name {}", (Object)this.getID());
            this.jchannel = new JChannel();
            this.jchannel.setReceiver((Receiver)new ReceiverAdapter(){

                public void receive(Message message) {
                    BroadcastMessage b;
                    Object msg = message.getObject();
                    if (msg != null && BroadcastMessage.class.isAssignableFrom(msg.getClass()) && (b = (BroadcastMessage)BroadcastMessage.class.cast(msg)).getTopicId().equalsIgnoreCase(JGroupsBroadcaster.this.getID())) {
                        JGroupsBroadcaster.this.broadcastReceivedMessage(b.getMessage());
                    }
                }
            });
            this.jchannel.connect(this.getID());
        }
        catch (Throwable t) {
            logger.warn("failed to connect to JGroups channel", t);
        }
        finally {
            this.ready.countDown();
        }
    }

    public void outgoingBroadcast(Object message) {
        try {
            this.ready.await();
            this.jchannel.send(new Message(null, null, (Object)new BroadcastMessage(this.getID(), message)));
        }
        catch (Throwable e) {
            logger.error("failed to send messge over Jgroups channel", (Object)e.getMessage());
        }
    }

    public synchronized void destroy() {
        super.destroy();
        if (!this.jchannel.isOpen()) {
            return;
        }
        try {
            Util.shutdown((Channel)this.jchannel);
        }
        catch (Throwable t) {
            Util.close((Channel)this.jchannel);
            logger.warn("failed to properly shutdown jgroups channel, closing abnormally", t);
        }
    }

    public static class BroadcastMessage
    implements Serializable {
        private final String topicId;
        private final Object message;

        public BroadcastMessage(String topicId, Object message) {
            this.topicId = topicId;
            this.message = message;
        }

        public String getTopicId() {
            return this.topicId;
        }

        public Object getMessage() {
            return this.message;
        }
    }
}

