/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.cluster.jms;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.InitialContext;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.atmosphere.util.LoggerUtils;

public class JMSFilter
implements MessageListener,
ClusterBroadcastFilter {
    private static Logger logger = LoggerUtils.getLogger();
    private Connection connection;
    private Session session;
    private MessageConsumer consumer;
    private MessageProducer publisher;
    private String clusterName;
    private Broadcaster bc = null;
    private final ConcurrentLinkedQueue<String> receivedMessages = new ConcurrentLinkedQueue();

    public JMSFilter() {
        this(null);
    }

    public JMSFilter(Broadcaster bc) {
        this(bc, "atmosphere-framework");
    }

    public JMSFilter(Broadcaster bc, String containerName) {
        this(bc, containerName, "cluster-atmosphere");
    }

    public JMSFilter(Broadcaster bc, String containerName, String clusterName) {
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void init() {
        try {
            InitialContext ctx = new InitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup("jms/atmosphereFactory");
            Topic topic = (Topic)ctx.lookup("jms/" + this.clusterName);
            this.connection = connectionFactory.createConnection();
            this.session = this.connection.createSession(false, 1);
            this.consumer = this.session.createConsumer((Destination)topic, this.clusterName);
            this.consumer.setMessageListener((MessageListener)this);
            this.publisher = this.session.createProducer((Destination)topic);
            this.connection.start();
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Unable to initialize JMSFilter", ex);
        }
    }

    public void destroy() {
    }

    public void onMessage(Message msg) {
        block3: {
            try {
                TextMessage textMessage = (TextMessage)msg;
                String message = textMessage.getText();
                this.receivedMessages.offer(message);
                if (message != null && this.bc != null) {
                    this.bc.broadcast((Object)message);
                }
            }
            catch (JMSException ex) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, "", ex);
            }
        }
    }

    public BroadcastFilter.BroadcastAction filter(Object o) {
        if (o instanceof String) {
            String message = (String)o;
            try {
                if (!this.receivedMessages.remove(message)) {
                    this.publisher.send((Message)this.session.createTextMessage(message));
                }
            }
            catch (JMSException ex) {
                logger.log(Level.WARNING, "", ex);
            }
            return new BroadcastFilter.BroadcastAction((Object)message);
        }
        return new BroadcastFilter.BroadcastAction(o);
    }

    public Broadcaster getBroadcaster() {
        return this.bc;
    }

    public void setBroadcaster(Broadcaster bc) {
        this.bc = bc;
    }
}

