/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.InitialContext;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.util.AbstractBroadcasterProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSBroadcaster
extends AbstractBroadcasterProxy {
    private static final String JMS_TOPIC = JMSBroadcaster.class.getName() + ".topic";
    private static final String JNDI_NAMESPACE = JMSBroadcaster.class.getName() + ".JNDINamespace";
    private static final String JNDI_FACTORY_NAME = JMSBroadcaster.class.getName() + ".JNDIConnectionFactoryName";
    private static final String JNDI_TOPIC = JMSBroadcaster.class.getName() + ".JNDITopic";
    private static final Logger logger = LoggerFactory.getLogger(JMSBroadcaster.class);
    private Connection connection;
    private Session session;
    private Topic topic;
    private MessageConsumer consumer;
    private MessageProducer publisher;
    private String topicId = "atmosphere";
    private String factoryName = "atmosphereFactory";
    private String namespace = "jms/";

    public JMSBroadcaster() {
        super(JMSBroadcaster.class.getSimpleName());
    }

    public JMSBroadcaster(String id) {
        super(id);
    }

    public synchronized void configure(AtmosphereServlet.AtmosphereConfig config) {
        try {
            if (config != null) {
                if (config.getInitParameter(JMS_TOPIC) != null) {
                    this.topicId = config.getInitParameter(JMS_TOPIC);
                }
                if (config.getInitParameter(JNDI_NAMESPACE) != null) {
                    this.namespace = config.getInitParameter(JNDI_NAMESPACE);
                }
                if (config.getInitParameter(JNDI_FACTORY_NAME) != null) {
                    this.factoryName = config.getInitParameter(JNDI_FACTORY_NAME);
                }
                if (config.getInitParameter(JNDI_TOPIC) != null) {
                    this.topicId = config.getInitParameter(JNDI_TOPIC);
                }
            }
            logger.info("Looking up Connection Factory {}", (Object)(this.namespace + this.factoryName));
            InitialContext ctx = new InitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup(this.namespace + this.factoryName);
            logger.info("Looking up topic: {}", (Object)this.topicId);
            this.topic = (Topic)ctx.lookup(this.namespace + this.topicId);
            this.connection = connectionFactory.createConnection();
            this.session = this.connection.createSession(false, 1);
            this.publisher = this.session.createProducer((Destination)this.topic);
            this.connection.start();
            logger.info("JMS created for topic {}", (Object)this.topicId);
            ((Object)((Object)this)).notify();
        }
        catch (Exception e) {
            String msg = "Unable to configure JMSBroadcaster";
            logger.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingBroadcast() {
        JMSBroadcaster jMSBroadcaster = this;
        synchronized (jMSBroadcaster) {
            while (this.session == null) {
                try {
                    ((Object)((Object)this)).wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.restartConsumer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setID(String id) {
        super.setID(id);
        JMSBroadcaster jMSBroadcaster = this;
        synchronized (jMSBroadcaster) {
            if (this.session != null) {
                this.restartConsumer();
            }
        }
    }

    void restartConsumer() {
        try {
            String id = this.getID();
            if (id.startsWith("/*")) {
                id = "atmosphere";
            }
            if (this.consumer != null) {
                this.consumer.close();
                this.consumer = null;
            }
            logger.info("Create JMS consumer: {}", (Object)id);
            String selector = String.format("BroadcasterId = '%s'", id);
            this.consumer = this.session.createConsumer((Destination)this.topic, selector);
            this.consumer.setMessageListener(new MessageListener(){

                public void onMessage(Message msg) {
                    try {
                        TextMessage textMessage = (TextMessage)msg;
                        String message = textMessage.getText();
                        if (message != null && JMSBroadcaster.this.bc != null) {
                            JMSBroadcaster.this.broadcastReceivedMessage(message);
                        }
                    }
                    catch (JMSException ex) {
                        logger.warn("Failed to broadcast message", (Throwable)ex);
                    }
                }
            });
            logger.info("Consumer created for topic {}, with filter {}", (Object)this.topicId, (Object)selector);
        }
        catch (Throwable ex) {
            String msg = "Unable to initialize JMSBroadcaster";
            logger.error(msg, ex);
            throw new IllegalStateException(msg, ex);
        }
    }

    public void outgoingBroadcast(Object message) {
        try {
            String id = this.getID();
            if (id.startsWith("/*")) {
                id = "atmosphere";
            }
            if (this.session == null) {
                throw new IllegalStateException("JMS Session is null");
            }
            TextMessage textMessage = this.session.createTextMessage(message.toString());
            textMessage.setStringProperty("BroadcasterId", id);
            this.publisher.send((Message)textMessage);
        }
        catch (JMSException ex) {
            logger.warn("Failed to send message over JMS", (Throwable)ex);
        }
    }

    public void releaseExternalResources() {
        try {
            this.connection.close();
            this.session.close();
            this.consumer.close();
            this.publisher.close();
        }
        catch (Throwable ex) {
            logger.warn("releaseExternalResources", ex);
        }
    }
}

