/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.jms;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.InitialContext;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.util.AbstractBroadcasterProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSBroadcaster
extends AbstractBroadcasterProxy {
    private static final String JMS_TOPIC = JMSBroadcaster.class.getName() + ".topic";
    private static final String JNDI_NAMESPACE = JMSBroadcaster.class.getName() + ".JNDINamespace";
    private static final String JNDI_FACTORY_NAME = JMSBroadcaster.class.getName() + ".JNDIConnectionFactoryName";
    private static final String JNDI_TOPIC = JMSBroadcaster.class.getName() + ".JNDITopic";
    private static final Logger logger = LoggerFactory.getLogger(JMSBroadcaster.class);
    private Connection connection;
    private Session consumerSession;
    private Session publisherSession;
    private Topic topic;
    private MessageConsumer consumer;
    private MessageProducer publisher;
    private String topicId = "atmosphere";
    private String factoryName = "atmosphereFactory";
    private String namespace = "jms/";

    public Broadcaster initialize(String id, URI uri, AtmosphereConfig config) {
        super.initialize(id, uri, config);
        this.setUp();
        return this;
    }

    private void setUp() {
        try {
            if (this.config.getInitParameter(JMS_TOPIC) != null) {
                this.topicId = this.config.getInitParameter(JMS_TOPIC);
            }
            if (this.config.getInitParameter(JNDI_NAMESPACE) != null) {
                this.namespace = this.config.getInitParameter(JNDI_NAMESPACE);
            }
            if (this.config.getInitParameter(JNDI_FACTORY_NAME) != null) {
                this.factoryName = this.config.getInitParameter(JNDI_FACTORY_NAME);
            }
            if (this.config.getInitParameter(JNDI_TOPIC) != null) {
                this.topicId = this.config.getInitParameter(JNDI_TOPIC);
            }
            logger.info("Looking up Connection Factory {}", (Object)(this.namespace + this.factoryName));
            InitialContext ctx = new InitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup(this.namespace + this.factoryName);
            logger.info("Looking up topic: {}", (Object)this.topicId);
            this.topic = (Topic)ctx.lookup(this.namespace + this.topicId);
            this.connection = connectionFactory.createConnection();
            this.consumerSession = this.connection.createSession(false, 1);
            this.publisherSession = this.connection.createSession(false, 1);
            this.publisher = this.publisherSession.createProducer((Destination)this.topic);
            this.connection.start();
            logger.info("JMS created for topic {}", (Object)this.topicId);
        }
        catch (Exception e) {
            String msg = "Unable to configure JMSBroadcaster";
            logger.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public void incomingBroadcast() {
    }

    public void setID(String id) {
        super.setID(id);
        this.restartConsumer();
    }

    void restartConsumer() {
        try {
            String id = this.getID();
            if (id.startsWith("/*")) {
                id = "atmosphere";
            }
            if (this.consumer != null) {
                this.consumer.close();
                this.consumer = null;
            }
            logger.info("Create JMS consumer: {}", (Object)id);
            String selector = String.format("BroadcasterId = '%s'", id);
            this.consumer = this.consumerSession.createConsumer((Destination)this.topic, selector);
            this.consumer.setMessageListener(new MessageListener(){

                public void onMessage(Message msg) {
                    try {
                        TextMessage textMessage = (TextMessage)msg;
                        String message = textMessage.getText();
                        if (message != null && JMSBroadcaster.this.bc != null) {
                            JMSBroadcaster.this.broadcastReceivedMessage(message);
                        }
                    }
                    catch (JMSException ex) {
                        logger.warn("Failed to broadcast message", (Throwable)ex);
                    }
                }
            });
            logger.info("Consumer created for topic {}, with filter {}", (Object)this.topicId, (Object)selector);
        }
        catch (Throwable ex) {
            String msg = "Unable to initialize JMSBroadcaster";
            logger.error(msg, ex);
            throw new IllegalStateException(msg, ex);
        }
    }

    public void outgoingBroadcast(Object message) {
        try {
            String id = this.getID();
            if (id.startsWith("/*")) {
                id = "atmosphere";
            }
            if (this.publisherSession == null) {
                throw new IllegalStateException("JMS Session is null");
            }
            TextMessage textMessage = this.publisherSession.createTextMessage(message.toString());
            textMessage.setStringProperty("BroadcasterId", id);
            this.publisher.send((Message)textMessage);
        }
        catch (JMSException ex) {
            logger.warn("Failed to send message over JMS", (Throwable)ex);
        }
    }

    public synchronized void releaseExternalResources() {
        try {
            this.connection.close();
            this.consumerSession.close();
            this.publisherSession.close();
            if (this.consumer != null) {
                this.consumer.close();
            }
            if (this.publisher != null) {
                this.publisher.close();
            }
        }
        catch (Throwable ex) {
            logger.warn("releaseExternalResources", ex);
        }
    }
}

