/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.jms;

import java.util.concurrent.ConcurrentLinkedQueue;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.InitialContext;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.atmosphere.plugin.jms.JMSBroadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSFilter
implements ClusterBroadcastFilter {
    private static final String JMS_TOPIC = JMSBroadcaster.class.getName() + ".topic";
    private static final String JNDI_NAMESPACE = JMSBroadcaster.class.getName() + ".JNDINamespace";
    private static final String JNDI_FACTORY_NAME = JMSBroadcaster.class.getName() + ".JNDIConnectionFactoryName";
    private static final String JNDI_TOPIC = JMSBroadcaster.class.getName() + ".JNDITopic";
    private static final Logger logger = LoggerFactory.getLogger(JMSFilter.class);
    private Connection connection;
    private Session session;
    private MessageConsumer consumer;
    private MessageProducer publisher;
    private String topicId = "atmosphere";
    private String factoryName = "atmosphereFactory";
    private String namespace = "jms/";
    private String clusterName;
    private Broadcaster bc = null;
    private final ConcurrentLinkedQueue<String> receivedMessages = new ConcurrentLinkedQueue();

    public JMSFilter() {
        this(null);
    }

    public JMSFilter(Broadcaster bc) {
        this(bc, "atmosphere-framework");
    }

    public JMSFilter(Broadcaster bc, String topicId) {
        this.bc = bc;
        this.topicId = topicId;
    }

    public void setUri(String clusterName) {
        this.clusterName = clusterName;
    }

    public void init(AtmosphereConfig config) {
        try {
            String id;
            if (config != null) {
                if (config.getInitParameter(JMS_TOPIC) != null) {
                    this.topicId = config.getInitParameter(JMS_TOPIC);
                }
                if (config.getInitParameter(JNDI_NAMESPACE) != null) {
                    this.namespace = config.getInitParameter(JNDI_NAMESPACE);
                }
                if (config.getInitParameter(JNDI_FACTORY_NAME) != null) {
                    this.factoryName = config.getInitParameter(JNDI_FACTORY_NAME);
                }
                if (config.getInitParameter(JNDI_TOPIC) != null) {
                    this.topicId = config.getInitParameter(JNDI_TOPIC);
                }
            }
            if ((id = this.bc.getID()).startsWith("/*")) {
                id = "atmosphere";
            }
            logger.info(String.format("Looking up Connection Factory %s", this.namespace + this.factoryName));
            InitialContext ctx = new InitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)ctx.lookup(this.namespace + this.factoryName);
            logger.info(String.format("Looking up topic: %s", this.topicId));
            Topic topic = (Topic)ctx.lookup(this.namespace + this.topicId);
            this.connection = connectionFactory.createConnection();
            this.session = this.connection.createSession(false, 1);
            logger.info(String.format("Create customer: %s", id));
            String selector = String.format("BroadcasterId = '%s'", id);
            this.consumer = this.session.createConsumer((Destination)topic, selector);
            this.consumer.setMessageListener(new MessageListener(){

                public void onMessage(Message msg) {
                    try {
                        TextMessage textMessage = (TextMessage)msg;
                        String message = textMessage.getText();
                        if (message != null && JMSFilter.this.bc != null) {
                            JMSFilter.this.receivedMessages.offer(message);
                            JMSFilter.this.bc.broadcast((Object)message);
                        }
                    }
                    catch (JMSException ex) {
                        logger.warn("", (Throwable)ex);
                    }
                }
            });
            this.publisher = this.session.createProducer((Destination)topic);
            this.connection.start();
            logger.info(String.format("JMS created for topic %s, with filter %s", this.topicId, selector));
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Unable to initialize JMSBroadcaster", ex);
        }
    }

    public void destroy() {
    }

    public BroadcastFilter.BroadcastAction filter(String broadcasterId, Object originalMessage, Object o) {
        if (o instanceof String) {
            String message = (String)o;
            if (!this.receivedMessages.remove(message)) {
                try {
                    String id = this.bc.getID();
                    if (id.startsWith("/*")) {
                        id = "atmosphere";
                    }
                    TextMessage textMessage = this.session.createTextMessage(message.toString());
                    textMessage.setStringProperty("BroadcasterId", id);
                    this.publisher.send((Message)textMessage);
                }
                catch (JMSException ex) {
                    logger.warn("failed to publish message", (Throwable)ex);
                }
            }
            return new BroadcastFilter.BroadcastAction((Object)message);
        }
        return new BroadcastFilter.BroadcastAction(o);
    }

    public Broadcaster getBroadcaster() {
        return this.bc;
    }

    public void setBroadcaster(Broadcaster bc) {
        this.bc = bc;
    }
}

