/*
 * 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2007-2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 */

package org.atmosphere.cpr;

import javax.servlet.ServletContext;


/**
 * A {@link AtmosphereEvent} encapsulates the mechanism to {@link #suspend()},
 * {@link #resume()} and broadcast ({@link #getBroadcaster()}) messages among
 * suspended response. {@link AtmosphereEvent} are passed at runtime to an
 * instance of {@link AtmosphereHandler}.
 * 
 * @author Jeanfrancois Arcand
 */
public interface AtmosphereEvent<E,F> {

    /**
     * Complete the {@link HttpServletResponse} and finish/commit it. 
     */
    public void resume();

        
    /**
     * Return <tt>true<//tt> if that {@link AtmosphereEvent#suspend()} has been
     * invoked and set to <tt>true</tt>
     * @return <tt>true<//tt> if that {@link AtmosphereEvent#suspend()} has been
     * invoked and set to <tt>true</tt>
     */
    public boolean isSuspended();
    
    /**
     * Return <tt>true<//tt> if that {@link AtmosphereEvent#resume()} has been
     * invoked 
     * @return <tt>true<//tt> if that {@link AtmosphereEvent#resume()} has been
     * invoked and set to <tt>true</tt>
     */
    public boolean isResuming();
       
    /**
     * Suspend the {@link HttpServletResponse} indefinitely. 
     * Suspending a {@link HttpServletResponse} will
     * tell the underlying container to avoid recycling objects associated with
     * the current instance, and also to avoid commiting response.
     */
    public void suspend();

    /**
     * Suspend the {@link HttpServletResponse}. Suspending a {@link HttpServletResponse} will
     * tell the underlying container to avoid recycling objects associated with
     * the current instance, and also to avoid commiting response.
     * 
     * @param timeout The maximum amount of time, in milliseconds, 
     * a {@link HttpServletResponse} can be suspended. When the timeout expires (because 
     * nothing has been written or because the {@link AtmosphereEvent#resume()}
     * or {@link AtmosphereEvent#cancel()}), the {@link HttpServletResponse} will be automatically
     * resumed and commited. Usage of any methods of a {@link HttpServletResponse} that
     * times out will throw an {@link IllegalStateException}.
     *        
     */   
    public void suspend(long timeout);
          
    /**
     * Return the underlying <E> Request.
     * @return E the underlying Request.
     */
    public E getRequest();
    
    
    /**
     * Return the underlying <F> Response.
     * @return F the underlying Response.
     */
    public F getResponse();

    /**
     * Return the {@link ServletContext}
     * @return the {@link ServletContext}
     */
    public ServletContext getServletContext();
    
    /**
     * Return the current {@link Broadcaster}
     */
    public Broadcaster getBroadcaster();
        
    /**
     * Set the current {@link Broadcaster}
     */
    public void setBroadcaster(Broadcaster broadcaster);

    /**
     * Return the WebServer we are running on.
     * @return Return the WebServer we are running on.
     */
    public String getWebServerName();

    /**
     * Return the object that were pass to {@link Broadcaster#broadcast(java.lang.Object)}
     * @return the object that were pass to {@link Broadcaster#broadcast(java.lang.Object)}
     */
    public Object getMessage();
    
}
