/*
 * 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2007-2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 */

package org.atmosphere.cpr;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
/**
 * {@link AtmosphereEvent} implementation for supporting {@link HttpServletRequest}
 * and {@link HttpServletResponse}. 
 * 
 * @author Jeanfrancois Arcand
 */
public class AtmosphereEventImpl implements
        AtmosphereEvent<HttpServletRequest, HttpServletResponse> {
    
    // The {@link HttpServletRequest}
    private HttpServletRequest req;
    
    // The {@link HttpServletResponse}
    private HttpServletResponse res;
        
    // The upcoming Action.
    protected AtmosphereServlet.Action action = new AtmosphereServlet.Action();
    
    // The Broadcaster
    protected Broadcaster broadcaster;

    // Which container are we running on.
    protected String webServerName = "";

    // The current message
    protected Object message = null;
    
    // ServletContext
    private ServletContext servletContext = null;

    /**
     * Create an {@link AtmosphereEvent}.
     * @param webServerName The WebServer we are running on top of.
     * @param broadcaster The {@link Broadcaster}.
     * @param req The {@link HttpServletRequest}
     * @param res The {@link HttpServletResponse}
     */
    public AtmosphereEventImpl(ServletContext servletContext,
            String webServerName,Broadcaster broadcaster,
            HttpServletRequest req, HttpServletResponse res){
        this.req = req;
        this.res = res;
        this.broadcaster = broadcaster;
        this.webServerName = webServerName;
        this.servletContext = servletContext;
    }

    /**
     * {@inheritDoc}
     */
    public void resume() {
        action.type = AtmosphereServlet.Action.TYPE.RESUME;
    }
    
    /**
     * {@inheritDoc}
     */    
    public boolean isResuming() {
        return action.type == AtmosphereServlet.Action.TYPE.RESUME;
    }
    
    /**
     * {@inheritDoc}
     */    
    public boolean isSuspended() {
        return action.type == AtmosphereServlet.Action.TYPE.SUSPEND;
    }

    /**
     * {@inheritDoc}
     */    
    public void suspend() {
        suspend(-1);
    }

    /**
     * {@inheritDoc}
     */    
    public void suspend(long timeout) {
        action.type = AtmosphereServlet.Action.TYPE.SUSPEND;
        action.timeout = timeout;
    }

    /**
     * {@inheritDoc}
     */    
    public HttpServletRequest getRequest() {
        return req;
    }

    /**
     * {@inheritDoc}
     */    
    public HttpServletResponse getResponse() {
        return res;
    }

    /**
     * {@inheritDoc}
     */    
    public Broadcaster getBroadcaster(){
        return broadcaster;
    }
 
    /**
     * {@inheritDoc}
     */     
    public void setBroadcaster(Broadcaster broadcaster){
        this.broadcaster = broadcaster;
    }
    
    protected void reset(HttpServletRequest req, HttpServletResponse res){
        action.timeout = -1L;
        action.type = AtmosphereServlet.Action.TYPE.NONE;
        this.req = req;
        this.res= res;
    }

    /**
     * {@inheritDoc}
     */
    public String getWebServerName(){
        return webServerName;
    }

    /**
     * Return the object that were pass to {@link Broadcaster#broadcast(java.lang.Object)}
     * @return the object that were pass to {@link Broadcaster#broadcast(java.lang.Object)}
     */
    public Object getMessage(){
        return message;
    }

    /**
     * Set the message broadacasted using {@link Broadcaster#broadcast(java.lang.Object)}
     * @param message The message broadacasted using {@link Broadcaster#broadcast(java.lang.Object)}
     */
    protected void setMessage(Object message){
        this.message = message;
    }

    /**
     * {@inheritDoc}
     */
    public ServletContext getServletContext() {
        return servletContext;
    }
}
