/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.sun.enterprise.web.connector.grizzly.comet.CometContext;
import com.sun.enterprise.web.connector.grizzly.comet.CometEngine;
import com.sun.enterprise.web.connector.grizzly.comet.CometEvent;
import com.sun.enterprise.web.connector.grizzly.comet.CometHandler;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.cpr.WebContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishv2CometSupport
extends WebContainer
implements CometSupport {
    private static final String ATMOSPHERE = "/atmosphere";
    private String atmosphereCtx = "";

    public GlassFishv2CometSupport(Map<String, AtmosphereServlet.AtmosphereHandlerWrapper> atmosphereHandlers) {
        super(atmosphereHandlers);
        this.setWebServerName(this.getContainerName() + "-" + this.getContainerDottedVersion());
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.atmosphereCtx = sc.getServletContext().getContextPath() + ATMOSPHERE;
        CometEngine cometEngine = CometEngine.getEngine();
        CometContext context = cometEngine.register(this.atmosphereCtx);
        context.setExpirationDelay(-1L);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Created CometContext for " + this.atmosphereCtx);
        }
    }

    @Override
    public String getContainerName() {
        return "GlassFish";
    }

    @Override
    public String getContainerDottedVersion() {
        return "v2.x";
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        CometContext ctx = CometEngine.getEngine().getCometContext(this.atmosphereCtx);
        VoidCometHandler c = new VoidCometHandler(req, res);
        req.getSession().setAttribute(ATMOSPHERE, (Object)c.hashCode());
        AtmosphereServlet.Action action = this.suspended(req, res);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Suspending" + res);
            }
            ctx.setExpirationDelay(action.timeout);
            ctx.addCometHandler((CometHandler)c);
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            CometHandler handler;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Resuming" + res);
            }
            if ((handler = ctx.getCometHandler(((Integer)req.getAttribute(ATMOSPHERE)).intValue())) != null) {
                ctx.resumeCometHandler(handler);
            }
            req.removeAttribute(ATMOSPHERE);
            AtmosphereServlet.Action nextAction = this.resumed(req, res);
            if (nextAction.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Suspending after Resuming" + res);
                }
                ctx.setExpirationDelay(action.timeout);
                ctx.addCometHandler((CometHandler)c);
            }
        }
        return action;
    }

    private class VoidCometHandler
    implements CometHandler {
        HttpServletRequest req;
        HttpServletResponse res;

        public VoidCometHandler(HttpServletRequest req, HttpServletResponse res) {
            this.req = req;
            this.res = res;
        }

        public void attach(Object o) {
        }

        public void onEvent(CometEvent ce) throws IOException {
        }

        public void onInitialize(CometEvent ce) throws IOException {
        }

        public void onTerminate(CometEvent ce) throws IOException {
        }

        public void onInterrupt(CometEvent ce) throws IOException {
            try {
                this.req.removeAttribute(GlassFishv2CometSupport.ATMOSPHERE);
                GlassFishv2CometSupport.this.timedout(this.req, this.res);
            }
            catch (ServletException ex) {
                IOException e = new IOException();
                e.initCause(ex);
                throw e;
            }
        }
    }
}

