/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.cpr.WebContainer;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyCometSupport
extends WebContainer
implements CometSupport {
    public JettyCometSupport(Map<String, AtmosphereServlet.AtmosphereHandlerWrapper> atmosphereHandlers) {
        super(atmosphereHandlers);
        this.setWebServerName(this.getContainerName() + "-" + this.getContainerDottedVersion());
    }

    @Override
    public String getContainerName() {
        return "Jetty";
    }

    @Override
    public String getContainerDottedVersion() {
        return "6.1.x";
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Continuation c = ContinuationSupport.getContinuation((HttpServletRequest)req, null);
        AtmosphereServlet.Action action = null;
        if (c.isNew() && !c.isPending()) {
            action = this.suspended(req, res);
            if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Suspending " + res);
                }
                if (action.timeout != -1L) {
                    c.suspend(action.timeout);
                } else {
                    c.suspend(0L);
                }
            }
        } else if (c.isResumed()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Resuming " + res);
            }
            c.reset();
            this.resumed(req, res);
        }
        return action;
    }
}

