/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereEvent;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.Broadcaster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtmosphereEventImpl
implements AtmosphereEvent<HttpServletRequest, HttpServletResponse> {
    private HttpServletRequest req;
    private HttpServletResponse res;
    protected AtmosphereServlet.Action action = new AtmosphereServlet.Action();
    protected Broadcaster broadcaster;
    protected String webServerName = "";
    protected Object message = null;
    private ServletContext servletContext = null;

    public AtmosphereEventImpl(ServletContext servletContext, String webServerName, Broadcaster broadcaster, HttpServletRequest req, HttpServletResponse res) {
        this.req = req;
        this.res = res;
        this.broadcaster = broadcaster;
        this.webServerName = webServerName;
        this.servletContext = servletContext;
    }

    @Override
    public void resume() {
        this.action.type = AtmosphereServlet.Action.TYPE.RESUME;
    }

    @Override
    public boolean isResuming() {
        return this.action.type == AtmosphereServlet.Action.TYPE.RESUME;
    }

    @Override
    public boolean isSuspended() {
        return this.action.type == AtmosphereServlet.Action.TYPE.SUSPEND;
    }

    @Override
    public void suspend() {
        this.suspend(-1L);
    }

    @Override
    public void suspend(long timeout) {
        this.action.type = AtmosphereServlet.Action.TYPE.SUSPEND;
        this.action.timeout = timeout;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.req;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.res;
    }

    @Override
    public Broadcaster getBroadcaster() {
        return this.broadcaster;
    }

    @Override
    public void setBroadcaster(Broadcaster broadcaster) {
        this.broadcaster = broadcaster;
    }

    protected void reset(HttpServletRequest req, HttpServletResponse res) {
        this.action.timeout = -1L;
        this.action.type = AtmosphereServlet.Action.TYPE.NONE;
        this.req = req;
        this.res = res;
    }

    @Override
    public String getWebServerName() {
        return this.webServerName;
    }

    @Override
    public Object getMessage() {
        return this.message;
    }

    protected void setMessage(Object message) {
        this.message = message;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

