/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import org.atmosphere.cpr.AtmosphereEvent;
import org.atmosphere.cpr.AtmosphereEventImpl;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBroadcaster
implements Broadcaster<AtmosphereEventImpl> {
    private ConcurrentLinkedQueue<AtmosphereEventImpl> events = new ConcurrentLinkedQueue();
    private final AtmosphereHandler atmosphereHandler;
    private ExecutorService executorService;

    public DefaultBroadcaster(AtmosphereHandler atmosphereHandler) {
        this.atmosphereHandler = atmosphereHandler;
    }

    @Override
    public void broadcast(Object msg) {
        for (AtmosphereEventImpl event : this.events) {
            try {
                event.setMessage(msg);
                this.broadcast(event);
            }
            catch (IOException ex) {
                LoggerUtils.getLogger().log(Level.WARNING, "", ex);
            }
        }
    }

    @Override
    public void broadcast(Object msg, AtmosphereEventImpl event) {
        try {
            event.setMessage(msg);
            this.broadcast(event);
        }
        catch (IOException ex) {
            LoggerUtils.getLogger().log(Level.WARNING, "", ex);
        }
    }

    @Override
    public void broadcast(Object msg, Set<AtmosphereEventImpl> subset) {
        for (AtmosphereEventImpl event : subset) {
            try {
                event.setMessage(msg);
                this.broadcast(event);
            }
            catch (IOException ex) {
                LoggerUtils.getLogger().log(Level.WARNING, "", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast(final AtmosphereEvent event) throws IOException {
        if (this.executorService == null) {
            AtmosphereHandler atmosphereHandler = this.atmosphereHandler;
            synchronized (atmosphereHandler) {
                this.atmosphereHandler.onMessage(event);
            }
        }
        AtmosphereHandler atmosphereHandler = this.atmosphereHandler;
        synchronized (atmosphereHandler) {
            this.executorService.submit(new Runnable(){

                public void run() {
                    try {
                        DefaultBroadcaster.this.atmosphereHandler.onMessage(event);
                    }
                    catch (IOException ex) {
                        LoggerUtils.getLogger().log(Level.WARNING, "", ex);
                    }
                }
            });
        }
    }

    @Override
    public boolean addAtmosphereEvent(AtmosphereEventImpl event) {
        return this.events.offer(event);
    }

    @Override
    public boolean removeAtmosphereEvent(AtmosphereEventImpl event) {
        return this.events.remove(event);
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }
}

