/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.AtmosphereEvent;
import org.atmosphere.cpr.AtmosphereEventImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebContainer {
    private static final AtmosphereServlet.Action timedoutAction = new AtmosphereServlet.Action();
    protected Logger logger = LoggerUtils.getLogger();
    protected final Map<String, AtmosphereServlet.AtmosphereHandlerWrapper> atmosphereHandlers;
    protected static final String EVENT = "Context";
    private String webServerName = "";
    private ServletContext servletContext;

    public WebContainer(Map<String, AtmosphereServlet.AtmosphereHandlerWrapper> atmosphereHandlers) {
        this.atmosphereHandlers = atmosphereHandlers;
    }

    public void init(ServletConfig sc) throws ServletException {
        this.servletContext = sc.getServletContext();
    }

    public AtmosphereServlet.Action suspended(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("(suspend) invoked:\n HttpServletRequest: " + req + "\n HttpServletResponse: " + res);
        }
        return this.action(req, res);
    }

    AtmosphereServlet.Action action(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereEventImpl event = (AtmosphereEventImpl)req.getSession().getAttribute(EVENT);
        AtmosphereServlet.AtmosphereHandlerWrapper g = this.map(req.getServletPath());
        if (event == null || event.isSuspended()) {
            event = new AtmosphereEventImpl(this.servletContext, this.webServerName, g.broadcaster, req, res);
            req.getSession().setAttribute(EVENT, (Object)event);
        } else {
            event.reset(req, res);
        }
        AtmosphereServlet.Action action = ((AtmosphereEventImpl)g.atmosphereHandler.onEvent(event)).action;
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            g.broadcaster.addAtmosphereEvent(event);
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            g.broadcaster.removeAtmosphereEvent(event);
        }
        return action;
    }

    AtmosphereServlet.AtmosphereHandlerWrapper map(String servletPath) throws ServletException {
        AtmosphereServlet.AtmosphereHandlerWrapper g = this.atmosphereHandlers.get(servletPath);
        if (g == null) {
            throw new ServletException("Invalid AtmosphereHandler");
        }
        return g;
    }

    public AtmosphereServlet.Action resumed(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("(resumed) invoked:\n HttpServletRequest: " + req + "\n HttpServletResponse: " + res);
        }
        return this.action(req, res);
    }

    public AtmosphereServlet.Action timedout(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereEvent event;
        HttpSession session = req.getSession(false);
        if (session != null && (event = (AtmosphereEvent)session.getAttribute(EVENT)) != null) {
            this.map((String)req.getServletPath()).broadcaster.removeAtmosphereEvent(event);
        }
        return timedoutAction;
    }

    protected void setWebServerName(String webServerName) {
        this.webServerName = webServerName;
    }
}

