/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereEventImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jetty7CometSupport
extends AsynchronousProcessor
implements CometSupport<AtmosphereEventImpl> {
    public Jetty7CometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public String getContainerName() {
        return "Jetty";
    }

    @Override
    public String getContainerDottedVersion() {
        return "7.0.x";
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Continuation c = ContinuationSupport.getContinuation((ServletRequest)req);
        AtmosphereServlet.Action action = null;
        if (!c.isSuspended() && !c.isExpired()) {
            action = this.suspended(req, res);
            if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Suspending " + res);
                }
                if (action.timeout != -1L) {
                    c.setTimeout(action.timeout);
                }
                c.suspend();
            } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Resume " + res);
                }
                c.complete();
            }
        } else if (c.isExpired()) {
            this.timedout(req, res);
        }
        return action;
    }

    @Override
    public void action(AtmosphereEventImpl actionEvent) {
        if (actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME) {
            Continuation c = ContinuationSupport.getContinuation((ServletRequest)actionEvent.getRequest());
            c.complete();
        }
    }
}

