/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.apache.catalina.CometProcessor;
import org.atmosphere.container.BlockingIOCometSupport;
import org.atmosphere.container.GlassFishv2CometSupport;
import org.atmosphere.container.GlassFishv3CometSupport;
import org.atmosphere.container.GrizzlyCometSupport;
import org.atmosphere.container.JBossWebCometSupport;
import org.atmosphere.container.Jetty7CometSupport;
import org.atmosphere.container.JettyCometSupport;
import org.atmosphere.container.Servlet30Support;
import org.atmosphere.container.TomcatCometSupport;
import org.atmosphere.container.WebLogicCometSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.util.AtmosphereConfigReader;
import org.atmosphere.util.BroadcasterLookup;
import org.atmosphere.util.IntrospectionUtils;
import org.atmosphere.util.LoggerUtils;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;
import weblogic.servlet.http.AbstractAsyncServlet;
import weblogic.servlet.http.RequestResponseKey;

public class AtmosphereServlet
extends AbstractAsyncServlet
implements CometProcessor,
HttpEventServlet {
    private boolean useNativeImplementation = true;
    public static final String SERVLET_30 = "javax.servlet.AsyncListener";
    public static final String GLASSFISH_V2 = "com.sun.enterprise.web.connector.grizzly.comet.CometEngine";
    public static final String TOMCAT = "org.apache.coyote.http11.Http11NioProcessor";
    public static final String JBOSS_5 = "org.apache.coyote.http11.Http11AprProtocol";
    public static final String JETTY = "org.mortbay.util.ajax.Continuation";
    public static final String JETTY_7 = "org.eclipse.jetty.continuation.Continuation";
    public static final String GRIZZLY = "com.sun.grizzly.http.servlet.ServletAdapter";
    public static final String GLASSFISH_V3 = "com.sun.grizzly.comet.CometEngine";
    public static final String WEBLOGIC = "weblogic.servlet.http.FutureResponseModel";
    public static final String JBOSSWEB = "org.jboss.servlet.http.HttpEventFilter";
    public static final Logger logger = LoggerUtils.getLogger();
    private ArrayList<String> possibleAtmosphereHandlersCandidate = new ArrayList();
    protected Map<String, AtmosphereHandlerWrapper> atmosphereHandlers = new HashMap<String, AtmosphereHandlerWrapper>();
    protected CometSupport cometSupport;
    protected AtmosphereConfig config;

    public AtmosphereServlet() {
        if (System.getProperty("org.atmosphere.useNative") != null) {
            this.useNativeImplementation = Boolean.parseBoolean(System.getProperty("org.atmosphere.useNative"));
        }
    }

    public void addAtmosphereHandler(String mapping, AtmosphereHandler h) {
        if (mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        this.atmosphereHandlers.put(mapping, new AtmosphereHandlerWrapper(h));
    }

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        try {
            URL url = sc.getServletContext().getResource("/WEB-INF/classes/");
            URLClassLoader urlC = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
            this.loadAtmosphereDotXml(sc.getServletContext().getResourceAsStream("/META-INF/atmosphere.xml"), urlC);
            if (this.atmosphereHandlers.size() == 0) {
                logger.warning("Missing META-INF/atmosphere.xml. Will try to autodetect AtmosphereHandler");
                this.autoDetectAtmosphereHandlers(sc.getServletContext(), urlC);
            }
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
        this.autoDetectContainer();
        this.cometSupport.init(sc);
        this.initAtmosphereServletProcessor(sc);
    }

    void initAtmosphereServletProcessor(ServletConfig sc) throws ServletException {
        for (Map.Entry<String, AtmosphereHandlerWrapper> h : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandler a = h.getValue().atmosphereHandler;
            if (!(a instanceof AtmosphereServletProcessor)) continue;
            ((AtmosphereServletProcessor)a).init(sc);
        }
    }

    public void destroy() {
        for (Map.Entry<String, AtmosphereHandlerWrapper> h : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandler a = h.getValue().atmosphereHandler;
            h.getValue().broadcaster.destroy();
            this.config.getBroadcasterLookup().remove(h.getValue().broadcaster);
            if (!(a instanceof AtmosphereServletProcessor)) continue;
            ((AtmosphereServletProcessor)a).destroy();
        }
    }

    protected void loadAtmosphereDotXml(InputStream stream, URLClassLoader c) throws IOException {
        if (stream == null) {
            return;
        }
        AtmosphereConfigReader reader = new AtmosphereConfigReader(stream);
        Map<String, String> atmosphereHandlerNames = reader.getAtmosphereHandlers();
        Set<Map.Entry<String, String>> entries = atmosphereHandlerNames.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            try {
                AtmosphereHandler<HttpServletRequest, HttpServletResponse> g = !entry.getValue().equals(ReflectorServletProcessor.class.getName()) ? (AtmosphereHandler)c.loadClass(entry.getValue()).newInstance() : new ReflectorServletProcessor();
                logger.info("Sucessfully loaded " + g + " mapped to context-path " + entry.getKey());
                AtmosphereHandlerWrapper wrapper = new AtmosphereHandlerWrapper(g);
                this.atmosphereHandlers.put(entry.getKey(), wrapper);
                for (AtmosphereConfigReader.Property p : reader.getProperty(entry.getValue())) {
                    IntrospectionUtils.setProperty(g, p.name, p.value);
                }
                String broadcasterClass = reader.getBroadcasterClass(entry.getKey());
                if (broadcasterClass == null) continue;
                wrapper.broadcaster = (Broadcaster)c.loadClass(broadcasterClass).newInstance();
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Unable to load AtmosphereHandler class: " + entry.getValue(), t);
            }
        }
    }

    protected void autoDetectContainer() {
        this.config = new AtmosphereConfig();
        try {
            if (this.useNativeImplementation) {
                logger.info("Forcing the use of the container's native Comet API implementation instead of Servlet 3.0");
                throw new ClassNotFoundException("Skip");
            }
            Class.forName(SERVLET_30);
            this.cometSupport = new Servlet30Support(this.config);
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName(GLASSFISH_V3);
                this.cometSupport = new GlassFishv3CometSupport(this.config);
            }
            catch (ClassNotFoundException ex) {
                try {
                    Class.forName(JETTY);
                    this.cometSupport = new JettyCometSupport(this.config);
                }
                catch (ClassNotFoundException ex2) {
                    try {
                        Class.forName(JBOSSWEB);
                        this.cometSupport = new JBossWebCometSupport(this.config);
                    }
                    catch (ClassNotFoundException ex10) {
                        try {
                            Class.forName(TOMCAT);
                            this.cometSupport = new TomcatCometSupport(this.config);
                        }
                        catch (ClassNotFoundException ex3) {
                            try {
                                Class.forName(GRIZZLY);
                                this.cometSupport = new GrizzlyCometSupport(this.config);
                            }
                            catch (ClassNotFoundException ex4) {
                                try {
                                    Class.forName(GLASSFISH_V2);
                                    this.cometSupport = new GlassFishv2CometSupport(this.config);
                                }
                                catch (ClassNotFoundException ex5) {
                                    try {
                                        Class.forName(WEBLOGIC);
                                        this.cometSupport = new WebLogicCometSupport(this.config);
                                    }
                                    catch (ClassNotFoundException ex6) {
                                        try {
                                            Class.forName(JETTY_7);
                                            this.cometSupport = new Jetty7CometSupport(this.config);
                                        }
                                        catch (ClassNotFoundException ex7) {
                                            try {
                                                Class.forName(JBOSS_5);
                                                this.cometSupport = new TomcatCometSupport(this.config);
                                            }
                                            catch (ClassNotFoundException ex8) {
                                                this.cometSupport = new BlockingIOCometSupport(this.config);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        logger.info("Atmosphere Framework running under container " + this.cometSupport.getContainerName() + " version " + this.cometSupport.getContainerDottedVersion());
    }

    protected void autoDetectAtmosphereHandlers(ServletContext sc, URLClassLoader c) throws MalformedURLException, URISyntaxException {
        File f;
        String webInf = "/WEB-INF/classes/";
        String s = sc.getRealPath(webInf);
        if (s == null) {
            URL u = sc.getResource(webInf);
            s = u.getPath();
        }
        if ((f = new File(s)).isDirectory()) {
            this.getFiles(f);
            for (String className : this.possibleAtmosphereHandlersCandidate) {
                try {
                    className = className.substring(className.indexOf(webInf) + webInf.length(), className.lastIndexOf(".")).replace('/', '.');
                    AtmosphereHandler g = (AtmosphereHandler)c.loadClass(className).newInstance();
                    logger.info("Sucessfully loaded " + g + " mapped to context-path " + g.getClass().getSimpleName());
                    this.atmosphereHandlers.put("/" + g.getClass().getSimpleName(), new AtmosphereHandlerWrapper(g));
                }
                catch (Throwable t) {
                    logger.finest(className + " is not a AtmosphereHandler");
                }
            }
        }
    }

    void getFiles(File f) {
        File[] files;
        for (File test : files = f.listFiles()) {
            if (test.isDirectory()) {
                this.getFiles(test);
                continue;
            }
            String clazz = test.getAbsolutePath();
            if (!clazz.endsWith(".class")) continue;
            this.possibleAtmosphereHandlersCandidate.add(clazz);
        }
    }

    public void doHead(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doOptions(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doTrace(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            this.cometSupport.service(req, res);
        }
        catch (IllegalStateException ex) {
            if (ex.getMessage() != null && ex.getMessage().startsWith("Tomcat failed")) {
                logger.warning(ex.getMessage());
                logger.warning("Using the BlockingIOCometSupport.");
                this.cometSupport = new BlockingIOCometSupport(this.config);
                this.service(req, res);
            }
            logger.log(Level.SEVERE, "AtmosphereServlet exception", ex);
            throw ex;
        }
    }

    public void event(CometEvent cometEvent) throws IOException, ServletException {
        HttpServletRequest req = cometEvent.getHttpServletRequest();
        HttpServletResponse res = cometEvent.getHttpServletResponse();
        req.setAttribute("CometEvent", (Object)cometEvent);
        this.cometSupport.service(req, res);
    }

    public void event(HttpEvent httpEvent) throws IOException, ServletException {
        HttpServletRequest req = httpEvent.getHttpServletRequest();
        HttpServletResponse res = httpEvent.getHttpServletResponse();
        req.setAttribute("HttpEvent", (Object)httpEvent);
        this.cometSupport.service(req, res);
    }

    protected boolean doRequest(RequestResponseKey rrk) throws IOException, ServletException {
        try {
            rrk.getRequest().getSession().setAttribute("RequestResponseKey", (Object)rrk);
            Action action = this.cometSupport.service(rrk.getRequest(), rrk.getResponse());
            if (action.type == Action.TYPE.SUSPEND) {
                if (action.timeout == -1L) {
                    rrk.setTimeout(Integer.MAX_VALUE);
                } else {
                    rrk.setTimeout((int)action.timeout);
                }
            }
            return action.type == Action.TYPE.SUSPEND;
        }
        catch (IllegalStateException ex) {
            logger.log(Level.SEVERE, "AtmosphereServlet.doRequest exception", ex);
            throw ex;
        }
    }

    protected void doResponse(RequestResponseKey rrk, Object context) throws IOException, ServletException {
        rrk.getResponse().flushBuffer();
    }

    protected void doTimeout(RequestResponseKey rrk) throws IOException, ServletException {
        ((AsynchronousProcessor)this.cometSupport).timedout(rrk.getRequest(), rrk.getResponse());
    }

    public static class Action {
        public long timeout = -1L;
        public TYPE type;

        public Action() {
            this.type = TYPE.NONE;
        }

        public Action(TYPE type) {
            this.type = type;
        }

        public Action(TYPE type, long timeout) {
            this.timeout = timeout;
            this.type = type;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum TYPE {
            SUSPEND,
            RESUME,
            NONE,
            CANCEL;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AtmosphereConfig {
        protected AtmosphereHandler ah;
        private BroadcasterLookup bl = new BroadcasterLookup();

        protected Map<String, AtmosphereHandlerWrapper> handlers() {
            return AtmosphereServlet.this.atmosphereHandlers;
        }

        public ServletContext getServletContext() {
            return AtmosphereServlet.this.getServletContext();
        }

        public String getInitParameter(String name) {
            return AtmosphereServlet.this.getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return AtmosphereServlet.this.getInitParameterNames();
        }

        public ServletConfig getServletConfig() {
            return AtmosphereServlet.this.getServletConfig();
        }

        public String getWebServerName() {
            return AtmosphereServlet.this.cometSupport.getContainerName();
        }

        public String getWebServerVersion() {
            return AtmosphereServlet.this.cometSupport.getContainerDottedVersion();
        }

        public AtmosphereHandler getAtmosphereHandler() {
            return this.ah;
        }

        public BroadcasterLookup getBroadcasterLookup() {
            return this.bl;
        }
    }

    public static class AtmosphereHandlerWrapper {
        public AtmosphereHandler atmosphereHandler;
        public Broadcaster broadcaster;

        public AtmosphereHandlerWrapper(AtmosphereHandler g) {
            this.atmosphereHandler = g;
            this.broadcaster = new DefaultBroadcaster();
        }
    }
}

