/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.handler;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereEvent;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectorServletProcessor
extends AbstractReflectorAtmosphereHandler
implements AtmosphereServletProcessor {
    private String servletClass;
    private Servlet servlet;
    private ServletWrapper wrapper;
    public static final String ATMOSPHERE_EVENT = AtmosphereEvent.class.getName();
    public static final String ATMOSPHERE_HANDLER = ReflectorServletProcessor.class.getName();

    void loadServlet(ServletContext sc) throws MalformedURLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        URL url = sc.getResource("/WEB-INF/lib/");
        URLClassLoader urlC = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
        try {
            this.servlet = (Servlet)urlC.loadClass(this.getServletClass()).newInstance();
        }
        catch (NullPointerException ex) {
            this.servlet = (Servlet)Thread.currentThread().getContextClassLoader().loadClass(this.servletClass).newInstance();
        }
    }

    @Override
    public AtmosphereEvent onEvent(AtmosphereEvent<HttpServletRequest, HttpServletResponse> event) throws IOException {
        event.getRequest().setAttribute(ATMOSPHERE_EVENT, event);
        event.getRequest().setAttribute(ATMOSPHERE_HANDLER, (Object)this);
        try {
            this.wrapper.service((ServletRequest)event.getRequest(), (ServletResponse)event.getResponse());
        }
        catch (ServletException ex) {
            throw new RuntimeException(ex);
        }
        return event;
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        try {
            this.loadServlet(sc.getServletContext());
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
        this.servlet.init(sc);
        this.wrapper = new ServletWrapper();
    }

    @Override
    public void destroy() {
        if (this.servlet != null) {
            this.servlet.destroy();
        }
    }

    public String getServletClass() {
        return this.servletClass;
    }

    public void setServletClass(String servletClass) {
        this.servletClass = servletClass;
    }

    private class ServletWrapper
    extends HttpServlet {
        private ServletWrapper() {
        }

        public void destroy() {
            ReflectorServletProcessor.this.servlet.destroy();
        }

        public String getInitParameter(String name) {
            return this.getServletConfig().getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return this.getServletConfig().getInitParameterNames();
        }

        public ServletConfig getServletConfig() {
            return ReflectorServletProcessor.this.servlet.getServletConfig();
        }

        public ServletContext getServletContext() {
            return this.getServletConfig().getServletContext();
        }

        public String getServletInfo() {
            return ReflectorServletProcessor.this.servlet.getServletInfo();
        }

        public void init(ServletConfig config) throws ServletException {
        }

        public void init() throws ServletException {
        }

        public void log(String msg) {
            this.getServletContext().log(this.getServletName() + ": " + msg);
        }

        public void log(String message, Throwable t) {
            this.getServletContext().log(this.getServletName() + ": " + message, t);
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            ReflectorServletProcessor.this.servlet.service(req, res);
        }

        public String getServletName() {
            return ReflectorServletProcessor.this.servlet.getServletConfig().getServletName();
        }
    }
}

