/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereEventImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;
import weblogic.servlet.http.AbstractAsyncServlet;
import weblogic.servlet.http.RequestResponseKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebLogicCometSupport
extends AsynchronousProcessor
implements CometSupport<AtmosphereEventImpl> {
    public static final String RRK = "RequestResponseKey";

    public WebLogicCometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = this.suspended(req, res);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Suspending" + res);
            }
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Resuming" + res);
            }
            AtmosphereServlet.Action nextAction = this.resumed(req, res);
            if (nextAction.type == AtmosphereServlet.Action.TYPE.SUSPEND && this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Suspending after Resuming" + res);
            }
        }
        return action;
    }

    @Override
    public void action(AtmosphereEventImpl actionEvent) {
        block3: {
            if (actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME) {
                try {
                    RequestResponseKey rrk = (RequestResponseKey)actionEvent.getRequest().getSession().getAttribute(RRK);
                    AbstractAsyncServlet.notify((RequestResponseKey)rrk, null);
                }
                catch (IOException ex) {
                    if (!this.logger.isLoggable(Level.FINE)) break block3;
                    this.logger.log(Level.FINE, "", ex);
                }
            }
        }
    }
}

