/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.BroadcastFilterLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcasterConfig<F> {
    static final int numOfProcessor = Runtime.getRuntime().availableProcessors();
    private ConcurrentLinkedQueue<BroadcastFilter<F>> filters = new ConcurrentLinkedQueue();
    private ExecutorService executorService;
    private ExecutorService defaultExecutorService = this.executorService = Executors.newFixedThreadPool(numOfProcessor);

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public boolean addFilter(BroadcastFilter<F> e) {
        if (this.filters.contains(e)) {
            return false;
        }
        if (e instanceof BroadcastFilterLifecycle) {
            ((BroadcastFilterLifecycle)e).init();
        }
        return this.filters.offer(e);
    }

    public void destroy() {
        this.getExecutorService().shutdown();
        this.getDefaultExecutorService().shutdown();
        for (BroadcastFilter<F> f : this.filters) {
            if (!(f instanceof BroadcastFilterLifecycle)) continue;
            ((BroadcastFilterLifecycle)f).destroy();
        }
    }

    public boolean removeFilter(BroadcastFilter<F> e) {
        if (e instanceof BroadcastFilterLifecycle) {
            ((BroadcastFilterLifecycle)e).destroy();
        }
        return this.filters.remove(e);
    }

    public F filter(F object) {
        F transformed = object;
        for (BroadcastFilter<F> mf : this.filters) {
            transformed = mf.filter(transformed);
            if (transformed != null) continue;
            return null;
        }
        return transformed;
    }

    public ExecutorService getDefaultExecutorService() {
        return this.defaultExecutorService;
    }
}

