/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereEvent;
import org.atmosphere.cpr.AtmosphereEventImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBroadcaster
implements Broadcaster<HttpServletRequest, HttpServletResponse, String> {
    private final ConcurrentLinkedQueue<AtmosphereEvent<HttpServletRequest, HttpServletResponse>> events = new ConcurrentLinkedQueue();
    private BroadcasterConfig<String> bc;
    private final BlockingQueue<Entry> messages = new LinkedBlockingQueue<Entry>();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private Broadcaster.SCOPE scope = Broadcaster.SCOPE.APPLICATION;
    private String name = DefaultBroadcaster.class.getSimpleName();

    public DefaultBroadcaster() {
        this.bc = new BroadcasterConfig();
    }

    @Override
    public void destroy() {
        this.bc.destroy();
    }

    @Override
    public Iterator<AtmosphereEvent<HttpServletRequest, HttpServletResponse>> getAtmosphereEvents() {
        return this.events.iterator();
    }

    @Override
    public void setScope(Broadcaster.SCOPE scope) {
        this.scope = scope;
    }

    @Override
    public Broadcaster.SCOPE getScope() {
        return this.scope;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    final void start() {
        if (!this.started.getAndSet(true)) {
            this.bc.getExecutorService().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block23: {
                        Entry msg = null;
                        try {
                            msg = (Entry)DefaultBroadcaster.this.messages.take();
                            DefaultBroadcaster.this.bc.getExecutorService().submit(this);
                            if (msg.eventsToPush == null) {
                                Iterator i$ = DefaultBroadcaster.this.events.iterator();
                                while (i$.hasNext()) {
                                    AtmosphereEvent event2;
                                    AtmosphereEvent atmosphereEvent = event2 = (AtmosphereEvent)i$.next();
                                    synchronized (atmosphereEvent) {
                                        if (event2 instanceof AtmosphereEventImpl) {
                                            ((AtmosphereEventImpl)event2).setMessage(msg.message);
                                        }
                                        DefaultBroadcaster.this.broadcast(event2);
                                    }
                                }
                                break block23;
                            }
                            if (msg.eventsToPush instanceof AtmosphereEvent) {
                                AtmosphereEvent event;
                                AtmosphereEvent event2 = event = (AtmosphereEvent)msg.eventsToPush;
                                synchronized (event2) {
                                    if (event instanceof AtmosphereEventImpl) {
                                        ((AtmosphereEventImpl)event).setMessage(msg.message);
                                    }
                                    DefaultBroadcaster.this.broadcast(event);
                                    break block23;
                                }
                            }
                            if (msg.eventsToPush instanceof Set) {
                                Set events = (Set)msg.eventsToPush;
                                Iterator i$ = events.iterator();
                                while (i$.hasNext()) {
                                    AtmosphereEvent event;
                                    AtmosphereEvent atmosphereEvent = event = (AtmosphereEvent)i$.next();
                                    synchronized (atmosphereEvent) {
                                        if (event instanceof AtmosphereEventImpl) {
                                            ((AtmosphereEventImpl)event).setMessage(msg.message);
                                        }
                                        DefaultBroadcaster.this.broadcast(event);
                                    }
                                }
                            }
                        }
                        catch (InterruptedException ex) {
                            LoggerUtils.getLogger().log(Level.SEVERE, null, ex);
                        }
                        finally {
                            if (msg != null) {
                                msg.f.done();
                            }
                        }
                    }
                }
            });
        }
    }

    private final void broadcast(AtmosphereEvent event) {
        try {
            event.getAtmosphereConfig().getAtmosphereHandler().onMessage(event);
        }
        catch (IOException ex) {
            LoggerUtils.getLogger().log(Level.WARNING, "", ex);
        }
        catch (IllegalStateException ex) {
            LoggerUtils.getLogger().log(Level.WARNING, "", ex);
            this.removeAtmosphereEvent(event);
        }
    }

    @Override
    public BroadcasterFuture<String> broadcast(String msg) {
        this.start();
        msg = this.bc.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<String> f = new BroadcasterFuture<String>(msg);
        this.messages.offer(new Entry(msg, null, f));
        return f;
    }

    @Override
    public BroadcasterFuture<String> broadcast(String msg, AtmosphereEvent event) {
        this.start();
        msg = this.bc.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<String> f = new BroadcasterFuture<String>(msg);
        this.messages.offer(new Entry(msg, event, f));
        return f;
    }

    @Override
    public BroadcasterFuture<String> broadcast(String msg, Set<AtmosphereEvent> subset) {
        this.start();
        msg = this.bc.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<String> f = new BroadcasterFuture<String>(msg);
        this.messages.offer(new Entry(msg, subset, f));
        return f;
    }

    @Override
    public AtmosphereEvent<HttpServletRequest, HttpServletResponse> addAtmosphereEvent(AtmosphereEvent<HttpServletRequest, HttpServletResponse> event) {
        if (this.events.contains(event)) {
            return null;
        }
        this.events.offer(event);
        event.getAtmosphereConfig().getBroadcasterLookup().add(this);
        return event;
    }

    @Override
    public AtmosphereEvent<HttpServletRequest, HttpServletResponse> removeAtmosphereEvent(AtmosphereEvent<HttpServletRequest, HttpServletResponse> event) {
        if (!this.events.contains(event)) {
            return null;
        }
        this.events.remove(event);
        return event;
    }

    protected ConcurrentLinkedQueue<AtmosphereEvent<HttpServletRequest, HttpServletResponse>> atmosphereEvents() {
        return this.events;
    }

    @Override
    public void setBroadcasterConfig(BroadcasterConfig bc) {
        this.bc = bc;
    }

    @Override
    public BroadcasterConfig getBroadcasterConfig() {
        return this.bc;
    }

    private final class Entry {
        String message;
        Object eventsToPush;
        BroadcasterFuture f;

        Entry(String message, Object eventsToPush, BroadcasterFuture f) {
            this.message = message;
            this.eventsToPush = eventsToPush;
            this.f = f;
        }
    }
}

