/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.atmosphere.util.FilterConfigImpl;

public final class AtmosphereFilterChain
implements FilterChain {
    public static final int INCREMENT = 8;
    private FilterConfigImpl[] filters = new FilterConfigImpl[8];
    private int pos = 0;
    private int n = 0;
    private Servlet servlet = null;
    private ServletConfig configImpl;

    public void init() throws ServletException {
        for (FilterConfigImpl f : this.filters) {
            if (f == null) continue;
            f.getFilter().init((FilterConfig)f);
        }
        this.servlet.init(this.configImpl);
    }

    public void invokeFilterChain(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        this.pos = 0;
        this.doFilter(request, response);
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.pos < this.n) {
            FilterConfigImpl filterConfig = this.filters[this.pos++];
            Filter filter = null;
            try {
                filter = filterConfig.getFilter();
                filter.doFilter(request, response, (FilterChain)this);
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ServletException("Throwable", e);
            }
            return;
        }
        try {
            if (this.servlet != null) {
                this.servlet.service(request, response);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException("Throwable", e);
        }
    }

    public void addFilter(FilterConfigImpl filterConfig) {
        if (this.n == this.filters.length) {
            FilterConfigImpl[] newFilters = new FilterConfigImpl[this.n + 8];
            System.arraycopy(this.filters, 0, newFilters, 0, this.n);
            this.filters = newFilters;
        }
        this.filters[this.n++] = filterConfig;
    }

    public void recycle() {
        this.pos = 0;
    }

    public void setServlet(ServletConfig configImpl, Servlet servlet) {
        this.configImpl = configImpl;
        this.servlet = servlet;
    }

    public FilterConfigImpl getFilter(int i) {
        return this.filters[i];
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public ServletConfig getServletConfig() {
        return this.configImpl;
    }

    public void destroy() {
        for (FilterConfigImpl filter : this.filters) {
            if (filter == null) continue;
            filter.recycle();
        }
        this.filters = null;
    }
}

