/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.plugin.rabbitmq.RabbitMQBroadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQConnectionFactory
implements AtmosphereConfig.ShutdownHook,
ShutdownListener {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQBroadcaster.class);
    private static RabbitMQConnectionFactory factory;
    public static final String PARAM_HOST;
    public static final String PARAM_USER;
    public static final String PARAM_PASS;
    public static final String PARAM_EXCHANGE_TYPE;
    public static final String PARAM_VHOST;
    public static final String PARAM_PORT;
    public static final String PARAM_USE_SSL;
    private String exchangeName;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Channel channel;
    private String exchange;
    private volatile boolean shutdown = true;
    private String host;
    private String vhost;
    private String user;
    private String port;
    private String password;
    private boolean useSsl;

    public RabbitMQConnectionFactory(AtmosphereConfig config) {
        String s = config.getInitParameter(PARAM_EXCHANGE_TYPE);
        this.exchange = s != null ? s : "topic";
        this.host = config.getInitParameter(PARAM_HOST);
        if (this.host == null) {
            this.host = "127.0.0.1";
        }
        this.vhost = config.getInitParameter(PARAM_VHOST);
        if (this.vhost == null) {
            this.vhost = "/";
        }
        this.user = config.getInitParameter(PARAM_USER);
        if (this.user == null) {
            this.user = "guest";
        }
        this.useSsl = Boolean.valueOf(config.getInitParameter(PARAM_USE_SSL, "false"));
        this.port = config.getInitParameter(PARAM_PORT);
        if (this.port == null) {
            this.port = this.useSsl ? "5671" : "5672";
        }
        this.password = config.getInitParameter(PARAM_PASS);
        if (this.password == null) {
            this.password = "guest";
        }
        this.exchangeName = "atmosphere." + this.exchange;
        this.reInit();
        config.shutdownHook((AtmosphereConfig.ShutdownHook)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reInit() throws RuntimeException {
        if (!this.shutdown) return;
        Class<RabbitMQConnectionFactory> clazz = RabbitMQConnectionFactory.class;
        synchronized (RabbitMQConnectionFactory.class) {
            if (!this.shutdown) return;
            try {
                logger.debug("Create Connection Factory");
                this.connectionFactory = new ConnectionFactory();
                this.connectionFactory.setUsername(this.user);
                this.connectionFactory.setPassword(this.password);
                this.connectionFactory.setVirtualHost(this.vhost);
                this.connectionFactory.setHost(this.host);
                this.connectionFactory.setPort(Integer.valueOf(this.port).intValue());
                if (this.useSsl) {
                    this.connectionFactory.useSslProtocol();
                }
                logger.debug("Try to acquire a connection ...");
                this.connection = this.connectionFactory.newConnection();
                this.channel = this.connection.createChannel();
                this.channel.addShutdownListener((ShutdownListener)this);
                logger.debug("Topic creation '{}'...", (Object)this.exchangeName);
                this.channel.exchangeDeclare(this.exchangeName, this.exchange);
                this.shutdown = false;
            }
            catch (Exception e) {
                String msg = "Unable to configure RabbitMQBroadcaster";
                logger.error(msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
            return;
        }
    }

    public static final RabbitMQConnectionFactory getFactory(AtmosphereConfig config) {
        if (factory == null) {
            factory = new RabbitMQConnectionFactory(config);
        }
        return factory;
    }

    public String exchangeName() {
        return this.exchangeName;
    }

    public Channel channel() {
        if (this.shutdown) {
            this.reInit();
        }
        return this.channel;
    }

    public void shutdown() {
        try {
            this.channel.close();
            this.connection.close();
        }
        catch (IOException | TimeoutException e) {
            logger.trace("", (Throwable)e);
        }
    }

    public void shutdownCompleted(ShutdownSignalException cause) {
        logger.info("Recieved shutdownCompleted", (Throwable)cause);
        this.shutdown = true;
    }

    static {
        PARAM_HOST = RabbitMQBroadcaster.class.getName() + ".host";
        PARAM_USER = RabbitMQBroadcaster.class.getName() + ".user";
        PARAM_PASS = RabbitMQBroadcaster.class.getName() + ".password";
        PARAM_EXCHANGE_TYPE = RabbitMQBroadcaster.class.getName() + ".exchange";
        PARAM_VHOST = RabbitMQBroadcaster.class.getName() + ".vhost";
        PARAM_PORT = RabbitMQBroadcaster.class.getName() + ".port";
        PARAM_USE_SSL = RabbitMQBroadcaster.class.getName() + ".ssl";
    }
}

