/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.redis.redisson;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.plugin.redis.redisson.RedissonBroadcaster;
import org.redisson.Config;
import org.redisson.Redisson;
import org.redisson.client.protocol.pubsub.Message;
import org.redisson.connection.LoadBalancer;
import org.redisson.connection.RandomLoadBalancer;
import org.redisson.core.MessageListener;
import org.redisson.core.PatternMessageListener;
import org.redisson.core.RPatternTopic;
import org.redisson.core.RTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonUtil {
    private static final Logger logger = LoggerFactory.getLogger(RedissonBroadcaster.class);
    private static final String REDIS_AUTH = RedissonBroadcaster.class.getName() + ".authorization";
    private static final String REDIS_SERVER = RedissonBroadcaster.class.getName() + ".server";
    private static final String REDIS_OTHERS = RedissonBroadcaster.class.getName() + ".others";
    private static final String REDIS_TYPE = RedissonBroadcaster.class.getName() + ".type";
    private static final String REDIS_SCAN_INTERVAL = RedissonBroadcaster.class.getName() + ".scan.interval";
    private static final String REDIS_SENTINEL_MASTER_NAME = RedissonBroadcaster.class.getName() + ".master.name";
    private Redisson redisson;
    private final AtmosphereConfig config;
    private URI uri;
    private final Callback callback;

    public RedissonUtil(URI uri, AtmosphereConfig config, Callback callback) {
        this.config = config;
        this.callback = callback;
        this.uri = uri;
    }

    public void configure() {
        String authToken = "";
        String redisType = "";
        if (this.config.getServletConfig().getInitParameter(REDIS_TYPE) != null) {
            redisType = this.config.getServletConfig().getInitParameter(REDIS_TYPE);
        }
        if (this.config.getServletConfig().getInitParameter(REDIS_AUTH) != null) {
            authToken = this.config.getServletConfig().getInitParameter(REDIS_AUTH);
        }
        if (this.config.getServletConfig().getInitParameter(REDIS_SERVER) != null) {
            this.uri = URI.create(this.config.getServletConfig().getInitParameter(REDIS_SERVER));
        } else if (this.uri == null) {
            throw new NullPointerException("uri cannot be null");
        }
        Config redissonConfig = new Config();
        if (redisType.isEmpty() || redisType.equals(RedisType.SINGLE.getStringValue())) {
            redissonConfig.useSingleServer().setAddress(this.uri.getHost() + ":" + this.uri.getPort());
            redissonConfig.useSingleServer().setDatabase(1);
            if (!authToken.isEmpty()) {
                redissonConfig.useSingleServer().setPassword(authToken);
            }
        } else {
            List<String> slaveList = Arrays.asList(this.config.getServletConfig().getInitParameter(REDIS_OTHERS).split("\\s*,\\s*"));
            Integer scanInterval = 2000;
            if (this.config.getServletConfig().getInitParameter(REDIS_SCAN_INTERVAL) != null) {
                scanInterval = Integer.parseInt(this.config.getServletConfig().getInitParameter(REDIS_SCAN_INTERVAL));
            }
            if (redisType.equals(RedisType.MASTER.getStringValue())) {
                redissonConfig.useMasterSlaveConnection().setMasterAddress(this.uri.getHost() + ":" + this.uri.getPort()).setLoadBalancer((LoadBalancer)new RandomLoadBalancer());
                for (String slave : slaveList) {
                    URI serverAddress = URI.create(slave);
                    redissonConfig.useMasterSlaveConnection().addSlaveAddress(new String[]{serverAddress.getHost() + ":" + serverAddress.getPort()});
                }
                if (!authToken.isEmpty()) {
                    redissonConfig.useMasterSlaveConnection().setPassword(authToken);
                }
            } else if (redisType.equals(RedisType.CLUSTER.getStringValue())) {
                redissonConfig.useClusterServers().setScanInterval(scanInterval.intValue()).addNodeAddress(new String[]{this.uri.getHost() + ":" + this.uri.getPort()});
                for (String slave : slaveList) {
                    URI serverAddress = URI.create(slave);
                    redissonConfig.useClusterServers().addNodeAddress(new String[]{serverAddress.getHost() + ":" + serverAddress.getPort()});
                }
                if (!authToken.isEmpty()) {
                    redissonConfig.useClusterServers().setPassword(authToken);
                }
            } else if (redisType.equals(RedisType.SENTINEL.getStringValue())) {
                String masterName = "";
                if (this.config.getServletConfig().getInitParameter(REDIS_SENTINEL_MASTER_NAME) != null) {
                    masterName = this.config.getServletConfig().getInitParameter(REDIS_SENTINEL_MASTER_NAME);
                } else if (masterName.isEmpty()) {
                    throw new NullPointerException("SENTINEL MASTER NAME cannot be null");
                }
                redissonConfig.useSentinelConnection().setMasterName(masterName).addSentinelAddress(new String[]{this.uri.getHost() + ":" + this.uri.getPort()});
                for (String slave : slaveList) {
                    URI serverAddress = URI.create(slave);
                    redissonConfig.useSentinelConnection().addSentinelAddress(new String[]{serverAddress.getHost() + ":" + serverAddress.getPort()});
                }
                if (!authToken.isEmpty()) {
                    redissonConfig.useSentinelConnection().setPassword(authToken);
                }
            } else if (redisType.equals(RedisType.ELASTICACHE.getStringValue())) {
                redissonConfig.useElasticacheServers().addNodeAddress(new String[]{this.uri.getHost() + ":" + this.uri.getPort()}).setScanInterval(scanInterval.intValue());
                if (!authToken.isEmpty()) {
                    redissonConfig.useElasticacheServers().setPassword(authToken);
                }
            }
        }
        try {
            this.redisson = Redisson.create((Config)redissonConfig);
        }
        catch (Exception e) {
            logger.error("failed to connect redis", (Throwable)e);
            this.disconnectRedisson();
        }
    }

    public void disconnectRedisson() {
        this.redisson.shutdown();
    }

    public synchronized void setID(String id) {
        this.disconnectRedisson();
    }

    public void destroy() {
        try {
            this.disconnectRedisson();
        }
        catch (Throwable t) {
            logger.warn("Redisson error on close", t);
        }
    }

    public void incomingBroadcast() {
        String callbackId = this.callback.getID();
        logger.info("Subscribing to: {}", (Object)callbackId);
        if (!callbackId.contains("*")) {
            RTopic topic = this.redisson.getTopic(callbackId);
            topic.addListener((MessageListener)new MessageListener<String>(){

                public void onMessage(String channel, String message) {
                    RedissonUtil.this.callback.broadcastReceivedMessage(message);
                }
            });
        } else {
            RPatternTopic topic1 = this.redisson.getPatternTopic("topic1.*");
            topic1.addListener((PatternMessageListener)new PatternMessageListener<Message>(){

                public void onMessage(String pattern, String channel, Message msg) {
                    RedissonUtil.this.callback.broadcastReceivedMessage(msg.toString());
                }
            });
        }
    }

    public void outgoingBroadcast(Object message) {
        RTopic topic = this.redisson.getTopic(this.callback.getID());
        try {
            topic.publish((Object)message.toString());
        }
        catch (Exception e) {
            logger.warn("outgoingBroadcast exception", (Throwable)e);
        }
    }

    public static interface Callback {
        public String getID();

        public void broadcastReceivedMessage(String var1);
    }

    private static enum RedisType {
        SINGLE("single"),
        MASTER("master"),
        CLUSTER("cluster"),
        SENTINEL("sentinel"),
        ELASTICACHE("elasticache");

        private String stringValue;

        private RedisType(String s) {
            this.stringValue = s;
        }

        public String getStringValue() {
            return this.stringValue;
        }
    }
}

