/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.redis.redisson;

import java.net.URI;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.atmosphere.plugin.redis.redisson.RedissonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonFilter
implements ClusterBroadcastFilter {
    private static final Logger logger = LoggerFactory.getLogger(RedissonFilter.class);
    private Broadcaster bc;
    private final ExecutorService listener = Executors.newSingleThreadExecutor();
    private final ConcurrentLinkedQueue<String> receivedMessages = new ConcurrentLinkedQueue();
    private URI uri;
    private RedissonUtil redisUtil;
    private AtmosphereConfig config;
    private final ConcurrentLinkedQueue<String> localMessages = new ConcurrentLinkedQueue();
    private String auth;

    public RedissonFilter() {
        this(URI.create("http://localhost:6379"));
    }

    public RedissonFilter(URI uri) {
        this.uri = uri;
    }

    public void setUri(String address) {
        this.uri = URI.create(address);
    }

    public void init(AtmosphereConfig config) {
        this.config = config;
    }

    public void destroy() {
        this.listener.shutdownNow();
        this.redisUtil.destroy();
    }

    public BroadcastFilter.BroadcastAction filter(String broadcasterId, Object originalMessage, Object o) {
        String contents = originalMessage.toString();
        if (!this.localMessages.remove(contents)) {
            this.redisUtil.outgoingBroadcast(originalMessage.toString());
            return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.CONTINUE, o);
        }
        return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.ABORT, o);
    }

    public Broadcaster getBroadcaster() {
        return this.bc;
    }

    public void setBroadcaster(final Broadcaster bc) {
        this.bc = bc;
        this.redisUtil = new RedissonUtil(this.uri, this.config, new RedissonUtil.Callback(){

            @Override
            public String getID() {
                return bc.getID();
            }

            @Override
            public void broadcastReceivedMessage(String message) {
                RedissonFilter.this.localMessages.offer(message);
                bc.broadcast((Object)message);
            }
        });
        this.redisUtil.configure();
        this.listener.submit(new Runnable(){

            @Override
            public void run() {
                RedissonFilter.this.redisUtil.incomingBroadcast();
            }
        });
    }
}

