/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.redis;

import java.io.IOException;
import java.net.URI;
import org.atmosphere.util.AbstractBroadcasterProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;

public class RedisBroadcaster
extends AbstractBroadcasterProxy {
    private static final Logger logger = LoggerFactory.getLogger(RedisBroadcaster.class);
    private static final String REDIS_AUTH = RedisBroadcaster.class.getName() + ".authorization";
    private static final String REDIS_SERVER = RedisBroadcaster.class.getName() + ".server";
    private Jedis jedisSubscriber;
    private Jedis jedisPublisher;
    private URI uri;
    private String authToken = "atmosphere";

    public RedisBroadcaster() {
        this(RedisBroadcaster.class.getSimpleName(), URI.create("http://localhost:6379"));
    }

    public RedisBroadcaster(String id) {
        this(id, URI.create("http://localhost:6379"));
    }

    public RedisBroadcaster(URI uri) {
        this(RedisBroadcaster.class.getSimpleName(), uri);
    }

    public RedisBroadcaster(String id, URI uri) {
        super(id);
        this.uri = uri;
    }

    public String getAuth() {
        return this.authToken;
    }

    public void setAuth(String auth) {
        this.authToken = auth;
    }

    protected void start() {
        super.start();
    }

    public void setUp() {
        if (this.uri == null) {
            return;
        }
        if (this.config != null) {
            if (this.config.getServletConfig().getInitParameter(REDIS_AUTH) != null) {
                this.authToken = this.config.getServletConfig().getInitParameter(REDIS_AUTH);
            }
            if (this.config.getServletConfig().getInitParameter(REDIS_SERVER) != null) {
                this.uri = URI.create(this.config.getServletConfig().getInitParameter(REDIS_SERVER));
            }
        }
        this.jedisSubscriber = new Jedis(this.uri.getHost(), this.uri.getPort());
        try {
            this.jedisSubscriber.connect();
        }
        catch (IOException e) {
            logger.error("failed to connect subscriber", (Throwable)e);
        }
        this.jedisSubscriber.auth(this.authToken);
        this.jedisSubscriber.flushAll();
        this.jedisPublisher = new Jedis(this.uri.getHost(), this.uri.getPort());
        try {
            this.jedisPublisher.connect();
        }
        catch (IOException e) {
            logger.error("failed to connect publisher", (Throwable)e);
        }
        this.jedisPublisher.auth(this.authToken);
        this.jedisPublisher.flushAll();
    }

    public void setID(String id) {
        super.setID(id);
        this.disconnectPublisher();
        this.disconnectSubscriber();
        this.setUp();
        this.reconfigure();
    }

    public void destroy() {
        super.destroy();
        this.disconnectPublisher();
        this.disconnectSubscriber();
    }

    public void incomingBroadcast() {
        logger.info("Subscribing to: {}", (Object)this.getID());
        this.jedisSubscriber.subscribe(new JedisPubSub(){

            public void onMessage(String channel, String message) {
                RedisBroadcaster.this.broadcastReceivedMessage(message);
            }

            public void onSubscribe(String channel, int subscribedChannels) {
                logger.debug("onSubscribe: {}", (Object)channel);
            }

            public void onUnsubscribe(String channel, int subscribedChannels) {
                logger.debug("onUnsubscribe: {}", (Object)channel);
            }

            public void onPSubscribe(String pattern, int subscribedChannels) {
                logger.debug("onPSubscribe: {}", (Object)pattern);
            }

            public void onPUnsubscribe(String pattern, int subscribedChannels) {
                logger.debug("onPUnsubscribe: {}", (Object)pattern);
            }

            public void onPMessage(String pattern, String channel, String message) {
                logger.debug("onPMessage: {}", (Object)(pattern + " " + channel + " " + message));
            }
        }, new String[]{this.getID()});
    }

    public void outgoingBroadcast(Object message) {
        this.jedisPublisher.publish(this.getID(), message.toString());
    }

    private void disconnectSubscriber() {
        if (this.jedisSubscriber != null) {
            try {
                this.jedisSubscriber.disconnect();
            }
            catch (IOException e) {
                logger.error("failed to disconnect subscriber", (Throwable)e);
            }
        }
    }

    private void disconnectPublisher() {
        if (this.jedisPublisher != null) {
            try {
                this.jedisPublisher.disconnect();
            }
            catch (IOException e) {
                logger.error("failed to disconnect publisher", (Throwable)e);
            }
        }
    }
}

