/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.redis;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;

public class RedisFilter
implements ClusterBroadcastFilter {
    private static final Logger logger = LoggerFactory.getLogger(RedisFilter.class);
    private Broadcaster bc;
    private final ExecutorService listener = Executors.newSingleThreadExecutor();
    private final ConcurrentLinkedQueue<String> receivedMessages = new ConcurrentLinkedQueue();
    private Jedis jedisSubscriber;
    private Jedis jedisPublisher;
    private URI uri;
    private String auth = "atmosphere";

    public RedisFilter() {
        this(RedisFilter.class.getSimpleName(), URI.create("http://localhost:6379"));
    }

    public RedisFilter(String id) {
        this(id, URI.create("http://localhost:6379"));
    }

    public RedisFilter(URI uri) {
        this(RedisFilter.class.getSimpleName(), uri);
    }

    public RedisFilter(String id, URI uri) {
        this.uri = uri;
    }

    public RedisFilter(Broadcaster bc, String address) {
        this.bc = bc;
        this.uri = URI.create(address);
        if (this.uri == null) {
            return;
        }
        this.jedisSubscriber = new Jedis(this.uri.getHost(), this.uri.getPort());
        try {
            this.jedisSubscriber.connect();
        }
        catch (IOException e) {
            logger.error("failed to connect to subscriber: " + this.jedisSubscriber, (Throwable)e);
        }
        this.jedisSubscriber.auth(this.auth);
        this.jedisSubscriber.flushAll();
        this.jedisPublisher = new Jedis(this.uri.getHost(), this.uri.getPort());
        try {
            this.jedisPublisher.connect();
        }
        catch (IOException e) {
            logger.error("failed to connect to publisher: " + this.jedisPublisher, (Throwable)e);
        }
        this.jedisPublisher.auth(this.auth);
        this.jedisPublisher.flushAll();
    }

    public void setUri(String address) {
        this.uri = URI.create(address);
    }

    public void init() {
        logger.info("Starting Atmosphere Redis Clustering support");
        final Broadcaster broadcaster = this.bc;
        this.listener.submit(new Runnable(){

            @Override
            public void run() {
                RedisFilter.this.jedisSubscriber.subscribe(new JedisPubSub(){

                    public void onMessage(String channel, String message) {
                        RedisFilter.this.receivedMessages.offer(message);
                        broadcaster.broadcast((Object)message);
                    }

                    public void onSubscribe(String channel, int subscribedChannels) {
                        logger.debug("onSubscribe(): channel: {}", (Object)channel);
                    }

                    public void onUnsubscribe(String channel, int subscribedChannels) {
                        logger.debug("onUnsubscribe(): channel: {}", (Object)channel);
                    }

                    public void onPSubscribe(String pattern, int subscribedChannels) {
                        logger.debug("onPSubscribe(): pattern: {}", (Object)pattern);
                    }

                    public void onPUnsubscribe(String pattern, int subscribedChannels) {
                        logger.debug("onPUnsubscribe(): pattern: {}", (Object)pattern);
                    }

                    public void onPMessage(String pattern, String channel, String message) {
                        logger.debug("onPMessage: pattern: {}, channel: {}, message: {}", new Object[]{pattern, channel, message});
                    }
                }, new String[]{RedisFilter.this.bc.getID()});
            }
        });
    }

    public void destroy() {
        this.listener.shutdownNow();
        try {
            this.jedisPublisher.disconnect();
            this.jedisSubscriber.disconnect();
        }
        catch (IOException e) {
            logger.error("failure encountered during destroy", (Throwable)e);
        }
    }

    public BroadcastFilter.BroadcastAction filter(Object originalMessage, Object o) {
        if (!this.receivedMessages.remove(originalMessage.toString())) {
            this.jedisPublisher.publish(this.bc.getID(), originalMessage.toString());
        }
        return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.CONTINUE, o);
    }

    public Broadcaster getBroadcaster() {
        return this.bc;
    }

    public void setBroadcaster(Broadcaster bc) {
        this.bc = bc;
    }
}

