/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.redis;

import java.net.URI;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.plugin.redis.RedisUtil;
import org.atmosphere.util.AbstractBroadcasterProxy;

public class RedisBroadcaster
extends AbstractBroadcasterProxy {
    private final RedisUtil redisUtil;

    public RedisBroadcaster(String id, AtmosphereConfig config) {
        this(URI.create("http://localhost:6379"), id, config);
    }

    public RedisBroadcaster(URI uri, String id, AtmosphereConfig config) {
        super(id, URI.create("http://localhost:6379"), config);
        this.redisUtil = new RedisUtil(uri, config, new RedisUtil.Callback(){

            @Override
            public String getID() {
                return RedisBroadcaster.this.getID();
            }

            @Override
            public void broadcastReceivedMessage(String message) {
                RedisBroadcaster.this.broadcastReceivedMessage(message);
            }
        });
    }

    public String getAuth() {
        return this.redisUtil.getAuth();
    }

    public void setAuth(String auth) {
        this.redisUtil.setAuth(auth);
    }

    public synchronized void setUp() {
        this.redisUtil.configure();
    }

    public synchronized void setID(String id) {
        super.setID(id);
        this.setUp();
        this.reconfigure();
    }

    public void destroy() {
        super.destroy();
        this.redisUtil.destroy();
    }

    public void incomingBroadcast() {
        this.redisUtil.incomingBroadcast();
    }

    public void outgoingBroadcast(Object message) {
        this.redisUtil.outgoingBroadcast(message);
    }
}

