/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.redis;

import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.plugin.redis.RedisBroadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisException;

public class RedisUtil {
    private static final Logger logger = LoggerFactory.getLogger(RedisBroadcaster.class);
    private static final String REDIS_AUTH = RedisBroadcaster.class.getName() + ".authorization";
    private static final String REDIS_SERVER = RedisBroadcaster.class.getName() + ".server";
    private static final String REDIS_SHARED_POOL = RedisBroadcaster.class.getName() + ".sharedPool";
    private Jedis jedisSubscriber;
    private Jedis jedisPublisher;
    private String authToken = null;
    private boolean sharedPool = false;
    private JedisPool jedisPool;
    private final AtmosphereConfig config;
    private URI uri;
    private final AtomicBoolean destroyed = new AtomicBoolean();
    private final Callback callback;

    public RedisUtil(URI uri, AtmosphereConfig config, Callback callback) {
        this.config = config;
        this.callback = callback;
        this.uri = uri;
    }

    public String getAuth() {
        return this.authToken;
    }

    public void setAuth(String auth) {
        this.authToken = auth;
    }

    public void configure() {
        if (this.config.getServletConfig().getInitParameter(REDIS_AUTH) != null) {
            this.authToken = this.config.getServletConfig().getInitParameter(REDIS_AUTH);
        }
        if (this.config.getServletConfig().getInitParameter(REDIS_SERVER) != null) {
            this.uri = URI.create(this.config.getServletConfig().getInitParameter(REDIS_SERVER));
        } else if (this.uri == null) {
            throw new NullPointerException("uri cannot be null");
        }
        if (this.config.getServletConfig().getInitParameter(REDIS_SHARED_POOL) != null) {
            this.sharedPool = Boolean.parseBoolean(this.config.getServletConfig().getInitParameter(REDIS_SHARED_POOL));
        }
        logger.info("{} shared connection pool {}", (Object)this.getClass().getName(), (Object)this.sharedPool);
        if (this.sharedPool) {
            if (this.config.properties().get(REDIS_SHARED_POOL) != null) {
                this.jedisPool = (JedisPool)this.config.properties().get(REDIS_SHARED_POOL);
            }
            if (this.jedisPool == null) {
                GenericObjectPool.Config gConfig = new GenericObjectPool.Config();
                gConfig.testOnBorrow = true;
                gConfig.testWhileIdle = true;
                this.jedisPool = new JedisPool(gConfig, this.uri.getHost(), this.uri.getPort());
                this.config.properties().put(REDIS_SHARED_POOL, this.jedisPool);
            } else {
                this.disconnectSubscriber();
            }
        }
        this.jedisSubscriber = new Jedis(this.uri.getHost(), this.uri.getPort());
        try {
            this.jedisSubscriber.connect();
            this.auth(this.jedisSubscriber);
        }
        catch (JedisException e) {
            logger.error("failed to connect subscriber", (Throwable)e);
            this.disconnectSubscriber();
        }
        Jedis jedis = this.jedisPublisher = this.sharedPool ? null : new Jedis(this.uri.getHost(), this.uri.getPort());
        if (!this.sharedPool) {
            try {
                this.jedisPublisher.connect();
                this.auth(this.jedisPublisher);
            }
            catch (JedisException e) {
                logger.error("failed to connect publisher", (Throwable)e);
                this.disconnectPublisher();
            }
        }
    }

    public synchronized void setID(String id) {
        this.disconnectPublisher();
        this.disconnectSubscriber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object lockingObject;
        Object object = lockingObject = this.getLockingObject();
        synchronized (object) {
            try {
                this.disconnectPublisher();
                this.disconnectSubscriber();
                if (this.jedisPool != null) {
                    this.jedisPool.destroy();
                }
            }
            catch (Throwable t) {
                logger.warn("Jedis error on close", t);
            }
            finally {
                this.config.properties().put(REDIS_SHARED_POOL, null);
            }
        }
    }

    public void incomingBroadcast() {
        logger.info("Subscribing to: {}", (Object)this.callback.getID());
        this.jedisSubscriber.subscribe(new JedisPubSub(){

            public void onMessage(String channel, String message) {
                RedisUtil.this.callback.broadcastReceivedMessage(message);
            }

            public void onSubscribe(String channel, int subscribedChannels) {
                logger.debug("onSubscribe: {}", (Object)channel);
            }

            public void onUnsubscribe(String channel, int subscribedChannels) {
                logger.debug("onUnsubscribe: {}", (Object)channel);
            }

            public void onPSubscribe(String pattern, int subscribedChannels) {
                logger.debug("onPSubscribe: {}", (Object)pattern);
            }

            public void onPUnsubscribe(String pattern, int subscribedChannels) {
                logger.debug("onPUnsubscribe: {}", (Object)pattern);
            }

            public void onPMessage(String pattern, String channel, String message) {
                logger.debug("onPMessage: pattern: {}, channel: {}, message: {}", new Object[]{pattern, channel, message});
            }
        }, new String[]{this.callback.getID()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outgoingBroadcast(Object message) {
        Object lockingObject;
        String contents = message.toString();
        Object object = lockingObject = this.getLockingObject();
        synchronized (object) {
            if (this.destroyed.get()) {
                logger.debug("JedisPool closed. Re-opening");
                this.setID(this.callback.getID());
            }
            if (this.sharedPool) {
                for (int i = 0; i < 10; ++i) {
                    boolean valid = true;
                    Jedis jedis = (Jedis)this.jedisPool.getResource();
                    try {
                        this.auth(jedis);
                        jedis.publish(this.callback.getID(), contents);
                    }
                    catch (JedisException e) {
                        valid = false;
                        logger.warn("outgoingBroadcast exception", (Throwable)e);
                    }
                    finally {
                        if (valid) {
                            this.jedisPool.returnResource((Object)jedis);
                        } else {
                            this.jedisPool.returnBrokenResource((Object)jedis);
                        }
                    }
                    if (!valid) {
                        continue;
                    }
                    break;
                }
            } else {
                try {
                    this.jedisPublisher.publish(this.callback.getID(), contents);
                }
                catch (JedisException e) {
                    logger.warn("outgoingBroadcast exception", (Throwable)e);
                }
            }
        }
    }

    private void auth(Jedis jedis) {
        if (this.authToken != null) {
            jedis.auth(this.authToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectSubscriber() {
        if (this.jedisSubscriber == null) {
            return;
        }
        Jedis jedis = this.jedisSubscriber;
        synchronized (jedis) {
            try {
                this.jedisSubscriber.disconnect();
            }
            catch (JedisException e) {
                logger.error("failed to disconnect subscriber", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectPublisher() {
        if (this.jedisPublisher == null) {
            return;
        }
        Jedis jedis = this.jedisPublisher;
        synchronized (jedis) {
            try {
                this.jedisPublisher.disconnect();
            }
            catch (JedisException e) {
                logger.error("failed to disconnect publisher", (Throwable)e);
            }
        }
    }

    private Object getLockingObject() {
        return this.sharedPool ? this.jedisPool : this.jedisPublisher;
    }

    public static interface Callback {
        public String getID();

        public void broadcastReceivedMessage(String var1);
    }
}

