/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.redis;

import java.net.URI;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.plugin.redis.RedisUtil;
import org.atmosphere.util.AbstractBroadcasterProxy;

public class RedisBroadcaster
extends AbstractBroadcasterProxy {
    private RedisUtil redisUtil;

    public Broadcaster initialize(String id, AtmosphereConfig config) {
        return this.initialize(id, URI.create("http://localhost:6379"), config);
    }

    public Broadcaster initialize(String id, URI uri, AtmosphereConfig config) {
        uri = URI.create("http://localhost:6379");
        super.initialize(id, uri, config);
        this.redisUtil = new RedisUtil(uri, config, new RedisUtil.Callback(){

            @Override
            public String getID() {
                return RedisBroadcaster.this.getID();
            }

            @Override
            public void broadcastReceivedMessage(String message) {
                RedisBroadcaster.this.broadcastReceivedMessage(message);
            }
        });
        this.setUp();
        return this;
    }

    public String getAuth() {
        return this.redisUtil.getAuth();
    }

    public void setAuth(String auth) {
        this.redisUtil.setAuth(auth);
    }

    public synchronized void setUp() {
        this.redisUtil.configure();
    }

    public synchronized void setID(String id) {
        super.setID(id);
        this.setUp();
        this.reconfigure();
    }

    public void destroy() {
        super.destroy();
        this.redisUtil.destroy();
    }

    public void incomingBroadcast() {
        this.redisUtil.incomingBroadcast();
    }

    public void outgoingBroadcast(Object message) {
        this.redisUtil.outgoingBroadcast(message);
    }
}

