/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.redis;

import java.net.URI;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.atmosphere.plugin.redis.RedisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisFilter
implements ClusterBroadcastFilter {
    private static final Logger logger = LoggerFactory.getLogger(RedisFilter.class);
    private Broadcaster bc;
    private final ExecutorService listener = Executors.newSingleThreadExecutor();
    private final ConcurrentLinkedQueue<String> receivedMessages = new ConcurrentLinkedQueue();
    private URI uri;
    private RedisUtil redisUtil;
    private AtmosphereConfig config;
    private final ConcurrentLinkedQueue<String> localMessages = new ConcurrentLinkedQueue();
    private String auth;

    public RedisFilter() {
        this(URI.create("http://localhost:6379"));
    }

    public RedisFilter(URI uri) {
        this.uri = uri;
    }

    public void setUri(String address) {
        this.uri = URI.create(address);
    }

    public void init(AtmosphereConfig config) {
        this.config = config;
    }

    public void destroy() {
        this.listener.shutdownNow();
        this.redisUtil.destroy();
    }

    public BroadcastFilter.BroadcastAction filter(String broadcasterId, Object originalMessage, Object o) {
        String contents = originalMessage.toString();
        if (!this.localMessages.remove(contents)) {
            this.redisUtil.outgoingBroadcast(originalMessage.toString());
            return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.CONTINUE, o);
        }
        return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.ABORT, o);
    }

    public Broadcaster getBroadcaster() {
        return this.bc;
    }

    public String getAuth() {
        return this.redisUtil.getAuth();
    }

    public void setAuth(String auth) {
        if (this.redisUtil != null) {
            this.redisUtil.setAuth(auth);
        } else {
            this.auth = auth;
        }
    }

    public void setBroadcaster(final Broadcaster bc) {
        this.bc = bc;
        this.redisUtil = new RedisUtil(this.uri, this.config, new RedisUtil.Callback(){

            @Override
            public String getID() {
                return bc.getID();
            }

            @Override
            public void broadcastReceivedMessage(String message) {
                RedisFilter.this.localMessages.offer(message);
                bc.broadcast((Object)message);
            }
        });
        this.redisUtil.configure();
        if (this.auth != null) {
            this.redisUtil.setAuth(this.auth);
        }
        this.listener.submit(new Runnable(){

            @Override
            public void run() {
                RedisFilter.this.redisUtil.incomingBroadcast();
            }
        });
    }
}

