/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBroadcaster
implements Broadcaster {
    private final ConcurrentLinkedQueue<AtmosphereResource> events = new ConcurrentLinkedQueue();
    private BroadcasterConfig bc;
    private final BlockingQueue<Entry> messages = new LinkedBlockingQueue<Entry>();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private Broadcaster.SCOPE scope = Broadcaster.SCOPE.APPLICATION;
    private String name = DefaultBroadcaster.class.getSimpleName();
    private final ConcurrentLinkedQueue<Entry> delayedBroadcast = new ConcurrentLinkedQueue();

    public DefaultBroadcaster() {
        this.bc = new BroadcasterConfig();
    }

    @Override
    public void destroy() {
        this.bc.destroy();
    }

    @Override
    public Iterator<AtmosphereResource> getAtmosphereResources() {
        return this.events.iterator();
    }

    @Override
    public void setScope(Broadcaster.SCOPE scope) {
        this.scope = scope;
    }

    @Override
    public Broadcaster.SCOPE getScope() {
        return this.scope;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    final void start() {
        if (!this.started.getAndSet(true)) {
            this.bc.getExecutorService().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Entry msg = null;
                    try {
                        msg = (Entry)DefaultBroadcaster.this.messages.take();
                        DefaultBroadcaster.this.bc.getExecutorService().submit(this);
                        if (!DefaultBroadcaster.this.delayedBroadcast.isEmpty()) {
                            Iterator i = DefaultBroadcaster.this.delayedBroadcast.iterator();
                            while (i.hasNext()) {
                                Entry e = (Entry)i.next();
                                try {
                                    DefaultBroadcaster.this.push(e);
                                }
                                finally {
                                    i.remove();
                                    e.f.done();
                                }
                            }
                        }
                        DefaultBroadcaster.this.push(msg);
                    }
                    catch (InterruptedException ex) {
                        LoggerUtils.getLogger().log(Level.SEVERE, null, ex);
                    }
                    finally {
                        if (msg != null) {
                            msg.f.done();
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void push(Entry msg) {
        block16: {
            AtmosphereResourceEventImpl e;
            block15: {
                e = null;
                if (msg.eventsToPush != null) break block15;
                Iterator<AtmosphereResource> i$ = this.events.iterator();
                while (i$.hasNext()) {
                    AtmosphereResource r2;
                    AtmosphereResource atmosphereResource = r2 = i$.next();
                    synchronized (atmosphereResource) {
                        if (r2 instanceof AtmosphereResourceImpl) {
                            e = ((AtmosphereResourceImpl)r2).event();
                            e.setMessage(msg.message);
                        }
                        this.broadcast(r2, e);
                    }
                }
                break block16;
            }
            if (msg.eventsToPush instanceof AtmosphereResourceEvent) {
                AtmosphereResource r;
                AtmosphereResource r2 = r = (AtmosphereResource)msg.eventsToPush;
                synchronized (r2) {
                    if (r instanceof AtmosphereResourceEventImpl) {
                        e = ((AtmosphereResourceImpl)r).event();
                        e.setMessage(msg.message);
                    }
                    this.broadcast(r, e);
                }
            }
            if (!(msg.eventsToPush instanceof Set)) break block16;
            Set sub = (Set)msg.eventsToPush;
            Iterator i$ = sub.iterator();
            while (i$.hasNext()) {
                AtmosphereResource r;
                AtmosphereResource atmosphereResource = r = (AtmosphereResource)i$.next();
                synchronized (atmosphereResource) {
                    if (r instanceof AtmosphereResourceEventImpl) {
                        e = ((AtmosphereResourceImpl)r).event();
                        e.setMessage(msg.message);
                    }
                    this.broadcast(r, e);
                }
            }
        }
    }

    private final void broadcast(AtmosphereResource r, AtmosphereResourceEvent e) {
        try {
            r.getAtmosphereConfig().getAtmosphereHandler().onStateChange(e);
        }
        catch (IOException ex) {
            LoggerUtils.getLogger().log(Level.WARNING, "", ex);
        }
        catch (IllegalStateException ex) {
            LoggerUtils.getLogger().log(Level.WARNING, "", ex);
            this.removeAtmosphereResource(r);
        }
    }

    public BroadcasterFuture<Object> broadcast(Object msg) {
        this.start();
        msg = this.bc.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        this.messages.offer(new Entry(msg, null, f));
        return f;
    }

    public BroadcasterFuture<Object> broadcast(Object msg, AtmosphereResource r) {
        this.start();
        msg = (String)this.bc.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        this.messages.offer(new Entry(msg, r, f));
        return f;
    }

    public BroadcasterFuture<Object> broadcast(Object msg, Set<AtmosphereResource> subset) {
        this.start();
        msg = (String)this.bc.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        this.messages.offer(new Entry(msg, subset, f));
        return f;
    }

    @Override
    public AtmosphereResource addAtmosphereResource(AtmosphereResource r) {
        if (this.events.contains(r)) {
            return null;
        }
        this.events.offer(r);
        r.getAtmosphereConfig().getBroadcasterLookup().add(this);
        return r;
    }

    @Override
    public AtmosphereResource removeAtmosphereResource(AtmosphereResource r) {
        if (!this.events.contains(r)) {
            return null;
        }
        this.events.remove(r);
        return r;
    }

    protected ConcurrentLinkedQueue<AtmosphereResource> atmosphereResources() {
        return this.events;
    }

    @Override
    public void setBroadcasterConfig(BroadcasterConfig bc) {
        this.bc = bc;
    }

    @Override
    public BroadcasterConfig getBroadcasterConfig() {
        return this.bc;
    }

    @Override
    public Future<Object> delayBroadcast(Object o) {
        return this.delayBroadcast(o, 0L, null);
    }

    @Override
    public Future<Object> delayBroadcast(final Object o, long delay, TimeUnit t) {
        if (t == null) {
            BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(o);
            this.delayedBroadcast.offer(new Entry(o, null, f));
            return f;
        }
        return this.bc.getScheduledExecutorService().schedule(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DefaultBroadcaster.this.broadcast(o);
                return o;
            }
        }, delay, t);
    }

    @Override
    public Future<?> scheduleFixedBroadcast(final Object o, long period, TimeUnit t) {
        if (period == 0L || t == null) {
            return null;
        }
        return this.bc.getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){

            public void run() {
                DefaultBroadcaster.this.broadcast(o);
            }
        }, 0L, period, t);
    }

    private final class Entry {
        Object message;
        Object eventsToPush;
        BroadcasterFuture f;

        Entry(Object message, Object eventsToPush, BroadcasterFuture f) {
            this.message = message;
            this.eventsToPush = eventsToPush;
            this.f = f;
        }
    }
}

