/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcasterLookup {
    private static final ConcurrentHashMap<Object, Broadcaster> store = new ConcurrentHashMap();

    public static final Broadcaster lookup(Class<? extends Broadcaster> c, Object id) {
        Broadcaster b = BroadcasterLookup.getBroadcaster(id);
        if (b != null && b.getScope() == Broadcaster.SCOPE.REQUEST) {
            throw new IllegalStateException("Broadcaster " + b + " cannot be looked up as its scope is REQUEST");
        }
        if (b != null && !b.getClass().equals(c)) {
            String em = "Invalid BroadcasterLookup class " + c.getName() + ". Cached class is: " + b.getClass().getName();
            LoggerUtils.getLogger().log(Level.WARNING, em);
            throw new IllegalStateException(em);
        }
        return b;
    }

    static Broadcaster getBroadcaster(Object name) {
        return store.get(name);
    }

    public static final boolean add(Broadcaster b, Object id) {
        return store.putIfAbsent(id, b) == null;
    }

    public static final boolean remove(Broadcaster b, Object id) {
        return store.remove(id) != null;
    }

    public static final Broadcaster build(Class<? extends Broadcaster> c, Object id) {
        Broadcaster b = null;
        try {
            b = c.newInstance();
        }
        catch (InstantiationException ex) {
            LoggerUtils.getLogger().log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            LoggerUtils.getLogger().log(Level.SEVERE, null, ex);
        }
        if (id instanceof String) {
            b.setID(id.toString());
        }
        store.put(id, b);
        return b;
    }

    public static final void destroy() {
        Enumeration<Broadcaster> e = store.elements();
        while (e.hasMoreElements()) {
            e.nextElement().destroy();
        }
    }
}

