/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.AtmosphereEventLifecycle;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.util.LoggerUtils;

public class DefaultBroadcaster
implements Broadcaster {
    protected final ConcurrentLinkedQueue<AtmosphereResource<?, ?>> events = new ConcurrentLinkedQueue();
    protected BroadcasterConfig bc = AtmosphereServlet.getBroadcasterConfig();
    protected final BlockingQueue<Entry> messages = new LinkedBlockingQueue<Entry>();
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected final AtomicBoolean destroyed = new AtomicBoolean(false);
    protected Broadcaster.SCOPE scope = Broadcaster.SCOPE.APPLICATION;
    protected String name = DefaultBroadcaster.class.getSimpleName();
    protected final ConcurrentLinkedQueue<Entry> delayedBroadcast = new ConcurrentLinkedQueue();
    private Future<?> notifierFuture;
    protected BroadcasterCache broadcasterCache;
    private Broadcaster.POLICY policy = Broadcaster.POLICY.FIFO;
    private long maxSuspendResource = -1L;
    private final AtomicBoolean requestScoped = new AtomicBoolean(false);

    public DefaultBroadcaster() {
        this(DefaultBroadcaster.class.getSimpleName());
    }

    public DefaultBroadcaster(String name) {
        this.name = name;
        this.setID(name);
        this.broadcasterCache = new BroadcasterConfig.DefaultBroadcasterCache();
    }

    @Override
    public void destroy() {
        if (this.notifierFuture != null) {
            this.notifierFuture.cancel(true);
        }
        if (this.bc != null && this.scope != Broadcaster.SCOPE.REQUEST) {
            this.bc.destroy();
        }
        if (this.broadcasterCache != null) {
            this.broadcasterCache.stop();
        }
        this.events.clear();
        this.messages.clear();
        this.delayedBroadcast.clear();
        this.broadcasterCache = null;
        this.started.set(false);
        this.destroyed.set(true);
        BroadcasterFactory.getDefault().remove(this, this.name);
    }

    @Override
    public Collection<AtmosphereResource<?, ?>> getAtmosphereResources() {
        return Collections.unmodifiableCollection(this.events);
    }

    @Override
    public void setScope(Broadcaster.SCOPE scope) {
        this.scope = scope;
        try {
            if (scope == Broadcaster.SCOPE.REQUEST) {
                for (AtmosphereResource<?, ?> r : this.events) {
                    Broadcaster b = BroadcasterFactory.getDefault().get(this.getClass(), this.getClass().getSimpleName() + "/" + UUID.randomUUID());
                    if (DefaultBroadcaster.class.isAssignableFrom(this.getClass())) {
                        ((DefaultBroadcaster)DefaultBroadcaster.class.cast((Object)b)).broadcasterCache = (BroadcasterCache)this.bc.getBroadcasterCache().getClass().newInstance();
                    }
                    r.setBroadcaster(b);
                    if (!r.getAtmosphereResourceEvent().isSuspended()) continue;
                    b.addAtmosphereResource(r);
                }
                if (!this.events.isEmpty()) {
                    this.destroy();
                }
            }
        }
        catch (Exception e) {
            LoggerUtils.getLogger().log(Level.SEVERE, "", e);
        }
    }

    @Override
    public Broadcaster.SCOPE getScope() {
        return this.scope;
    }

    @Override
    public void setID(String id) {
        Broadcaster b = BroadcasterFactory.getDefault().lookup(this.getClass(), id);
        if (b != null && b.getScope() == Broadcaster.SCOPE.REQUEST) {
            throw new IllegalStateException("Broadcaster ID already assigned to SCOPE.REQUEST. Cannot change the id");
        }
        BroadcasterFactory.getDefault().remove(this, this.name);
        this.name = id;
        BroadcasterFactory.getDefault().add(this, this.name);
    }

    @Override
    public String getID() {
        return this.name;
    }

    @Override
    public void resumeAll() {
        for (AtmosphereResource<?, ?> r : this.events) {
            r.resume();
        }
    }

    protected void start() {
        if (!this.started.getAndSet(true)) {
            if (this.bc == null) {
                LoggerUtils.getLogger().log(Level.WARNING, "BroadcasterConfig was null. It is recommended to use a BroadcasterFactory for creating Broadcaster instead of using new");
                this.bc = new BroadcasterConfig();
            }
            this.broadcasterCache = this.bc.getBroadcasterCache();
            this.broadcasterCache.start();
            this.notifierFuture = this.bc.getExecutorService().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Entry msg = null;
                    try {
                        msg = DefaultBroadcaster.this.messages.take();
                        DefaultBroadcaster.this.bc.getExecutorService().submit(this);
                        DefaultBroadcaster.this.push(msg);
                    }
                    catch (Throwable ex) {
                        LoggerUtils.getLogger().log(Level.SEVERE, null, ex);
                    }
                    finally {
                        if (msg != null) {
                            if (msg.future instanceof BroadcasterFuture) {
                                ((BroadcasterFuture)msg.future).done();
                            } else {
                                msg.future.cancel(true);
                            }
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void push(Entry msg) {
        String prevMessage = msg.message.toString();
        if (!this.delayedBroadcast.isEmpty()) {
            Iterator<Entry> i = this.delayedBroadcast.iterator();
            StringBuilder b = new StringBuilder();
            while (i.hasNext()) {
                Entry e = i.next();
                if (!(e.future instanceof BroadcasterFuture)) {
                    e.future.cancel(true);
                }
                try {
                    if (e.message instanceof String && msg.message instanceof String) {
                        b.append(e.message);
                        continue;
                    }
                    this.push(e);
                }
                finally {
                    i.remove();
                    if (!(e.future instanceof BroadcasterFuture)) continue;
                    ((BroadcasterFuture)e.future).done();
                }
            }
            if (b.length() > 0) {
                msg.message = b.append(msg.message).toString();
            }
        }
        if (this.events.isEmpty()) {
            this.trackBroadcastMessage(null, msg.message);
        }
        if (msg.eventsToPush == null) {
            for (AtmosphereResource<?, ?> r : this.events) {
                this.push(r, msg.message);
            }
        } else if (msg.eventsToPush instanceof AtmosphereResource) {
            this.push((AtmosphereResource)msg.eventsToPush, msg.message);
        } else if (msg.eventsToPush instanceof Set) {
            Set sub = (Set)msg.eventsToPush;
            for (AtmosphereResource r : sub) {
                this.push(r, msg.message);
            }
        }
        msg.message = prevMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void push(AtmosphereResource<?, ?> r, Object msg) {
        AtmosphereResourceEvent e = null;
        AtmosphereResource<?, ?> atmosphereResource = r;
        synchronized (atmosphereResource) {
            block8: {
                if (!r.getAtmosphereResourceEvent().isSuspended()) {
                    return;
                }
                this.trackBroadcastMessage(r, msg);
                e = r.getAtmosphereResourceEvent();
                e.setMessage(msg);
                if (r.getAtmosphereResourceEvent() != null && !r.getAtmosphereResourceEvent().isCancelled() && HttpServletRequest.class.isAssignableFrom(r.getRequest().getClass())) {
                    try {
                        ((HttpServletRequest)HttpServletRequest.class.cast(r.getRequest())).setAttribute(CometSupport.MAX_INACTIVE, (Object)System.currentTimeMillis());
                    }
                    catch (Throwable t) {
                        if (!LoggerUtils.getLogger().isLoggable(Level.FINE)) break block8;
                        LoggerUtils.getLogger().log(Level.FINE, "Preventing corruption of a recycled request", e);
                        this.events.remove(r);
                        return;
                    }
                }
            }
            this.broadcast(r, e);
            if (r instanceof AtmosphereEventLifecycle) {
                ((AtmosphereEventLifecycle)((Object)r)).notifyListeners();
            }
        }
    }

    protected void checkCachedAndPush(AtmosphereResource<?, ?> r, AtmosphereResourceEvent e) {
        this.retrieveTrackedBroadcast(r, e);
        if (e.getMessage() instanceof List && !((List)e.getMessage()).isEmpty()) {
            this.broadcast(r, e);
        }
    }

    protected boolean retrieveTrackedBroadcast(AtmosphereResource<?, ?> r, AtmosphereResourceEvent e) {
        List<Object> missedMsg = this.broadcasterCache.retrieveFromCache(r);
        if (!missedMsg.isEmpty()) {
            e.setMessage(missedMsg);
            return true;
        }
        return false;
    }

    protected void trackBroadcastMessage(AtmosphereResource<?, ?> r, Object msg) {
        this.broadcasterCache.addToCache(r, msg);
    }

    protected void broadcast(AtmosphereResource<?, ?> r, AtmosphereResourceEvent e) {
        try {
            r.getAtmosphereConfig().getAtmosphereHandler(this).onStateChange(e);
        }
        catch (IOException ex) {
            this.onException(ex, r);
        }
        catch (RuntimeException ex) {
            this.onException(ex, r);
        }
    }

    protected void onException(Throwable t, AtmosphereResource<?, ?> r) {
        if (LoggerUtils.getLogger().isLoggable(Level.FINE)) {
            LoggerUtils.getLogger().log(Level.FINE, "", t);
        }
        if (t instanceof IOException && r instanceof AtmosphereEventLifecycle) {
            ((AtmosphereEventLifecycle)((Object)r)).notifyListeners(new AtmosphereResourceEventImpl((AtmosphereResourceImpl)r, true, false));
            ((AtmosphereEventLifecycle)((Object)r)).removeEventListeners();
        }
        this.removeAtmosphereResource((AtmosphereResource)r);
    }

    @Override
    public void setSuspendPolicy(long maxSuspendResource, Broadcaster.POLICY policy) {
        this.maxSuspendResource = maxSuspendResource;
        this.policy = policy;
    }

    @Override
    public Future<Object> broadcast(Object msg) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        this.start();
        msg = this.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        this.messages.offer(new Entry(msg, null, f));
        return f;
    }

    protected Object filter(Object msg) {
        BroadcastFilter.BroadcastAction a = this.bc.filter(msg);
        if (a.action() == BroadcastFilter.BroadcastAction.ACTION.ABORT || msg == null) {
            return null;
        }
        return a.message();
    }

    @Override
    public Future<Object> broadcast(Object msg, AtmosphereResource<?, ?> r) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        this.start();
        msg = this.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        this.messages.offer(new Entry(msg, r, f));
        return f;
    }

    @Override
    public Future<Object> broadcast(Object msg, Set<AtmosphereResource<?, ?>> subset) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        this.start();
        msg = this.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        this.messages.offer(new Entry(msg, subset, f));
        return f;
    }

    @Override
    public AtmosphereResource<?, ?> addAtmosphereResource(AtmosphereResource<?, ?> r) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        if (this.scope == Broadcaster.SCOPE.REQUEST && this.requestScoped.getAndSet(true)) {
            throw new IllegalStateException("Broadcaster " + this + " cannot be used as its scope is set to REQUEST");
        }
        if (this.maxSuspendResource > 0L && (long)this.events.size() == this.maxSuspendResource) {
            if (this.policy == Broadcaster.POLICY.FIFO) {
                try {
                    this.events.poll().resume();
                }
                catch (Throwable t) {
                    LoggerUtils.getLogger().log(Level.WARNING, "addAtmosphereResource", t);
                }
            } else if (this.policy == Broadcaster.POLICY.REJECT) {
                throw new RejectedExecutionException(String.format("Maximum suspended AtmosphereResources %s", this.maxSuspendResource));
            }
        }
        if (this.events.contains(r)) {
            return r;
        }
        if (this.events.isEmpty()) {
            BroadcasterFactory.getDefault().add(this, this.name);
        }
        this.events.add(r);
        this.checkCachedAndPush(r, r.getAtmosphereResourceEvent());
        return r;
    }

    public AtmosphereResource<?, ?> removeAtmosphereResource(AtmosphereResource r) {
        if (!this.events.contains(r)) {
            return null;
        }
        this.events.remove(r);
        if (this.events.isEmpty()) {
            BroadcasterFactory.getDefault().remove(this, this.name);
        }
        return r;
    }

    @Override
    public void setBroadcasterConfig(BroadcasterConfig bc) {
        this.bc = bc;
    }

    @Override
    public BroadcasterConfig getBroadcasterConfig() {
        return this.bc;
    }

    @Override
    public Future<Object> delayBroadcast(Object o) {
        return this.delayBroadcast(o, 0L, null);
    }

    @Override
    public Future<Object> delayBroadcast(final Object o, long delay, TimeUnit t) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        final Object msg = this.filter(o);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture<Object> future = new BroadcasterFuture<Object>(msg);
        final Entry e = new Entry(msg, null, future);
        if (delay > 0L) {
            ScheduledFuture<Object> f = this.bc.getScheduledExecutorService().schedule(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DefaultBroadcaster.this.delayedBroadcast.remove(e);
                    if (Callable.class.isAssignableFrom(o.getClass())) {
                        try {
                            Object r = ((Callable)Callable.class.cast(o)).call();
                            if (r != null) {
                                Entry entry = new Entry(r, null, null);
                                DefaultBroadcaster.this.push(entry);
                            }
                            return msg;
                        }
                        catch (Exception e1) {
                            LoggerUtils.getLogger().log(Level.SEVERE, "", e);
                        }
                    }
                    DefaultBroadcaster.this.push(e);
                    return msg;
                }
            }, delay, t);
            e.future = f;
        }
        this.delayedBroadcast.offer(e);
        return future;
    }

    @Override
    public Future<?> scheduleFixedBroadcast(Object o, long period, TimeUnit t) {
        return this.scheduleFixedBroadcast(o, 0L, period, t);
    }

    @Override
    public Future<?> scheduleFixedBroadcast(final Object o, long waitFor, long period, TimeUnit t) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        if (period == 0L || t == null) {
            return null;
        }
        Object msg = this.filter(o);
        if (msg == null) {
            return null;
        }
        final Entry e = new Entry(o, null, null);
        return this.bc.getScheduledExecutorService().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (Callable.class.isAssignableFrom(o.getClass())) {
                    try {
                        Object r = ((Callable)Callable.class.cast(o)).call();
                        if (r != null) {
                            Entry entry = new Entry(r, null, null);
                            DefaultBroadcaster.this.push(entry);
                        }
                        return;
                    }
                    catch (Exception e1) {
                        LoggerUtils.getLogger().log(Level.SEVERE, "", e);
                    }
                }
                DefaultBroadcaster.this.push(e);
            }
        }, waitFor, period, t);
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "\n" + "\tName: " + this.name + "\n" + "\tScope: " + (Object)((Object)this.scope) + "\n" + "\tBroasdcasterCache " + this.broadcasterCache + "\n" + "\tAtmosphereResource: " + this.events.size() + "\n";
    }

    public class Entry {
        public Object message;
        public Object eventsToPush;
        public Future<?> future;

        public Entry(Object message, Object eventsToPush, Future future) {
            this.message = message;
            this.eventsToPush = eventsToPush;
            this.future = future;
        }
    }
}

