/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;

public class Jetty7CometSupport
extends AsynchronousProcessor
implements CometSupport<AtmosphereResourceImpl> {
    private final ConcurrentLinkedQueue<Continuation> resumed = new ConcurrentLinkedQueue();

    public Jetty7CometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = null;
        Continuation c = ContinuationSupport.getContinuation((ServletRequest)req);
        if (c.isInitial()) {
            action = this.suspended(req, res);
            if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Suspending " + res);
                }
                if (action.timeout != -1L) {
                    c.setTimeout(action.timeout);
                } else {
                    c.setTimeout(Integer.MAX_VALUE);
                }
                c.suspend();
                return action;
            } else {
                if (action.type != AtmosphereServlet.Action.TYPE.RESUME) return action;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Resume " + res);
                }
                if (this.resumed.remove(c)) return action;
                try {
                    c.complete();
                    return action;
                }
                catch (IllegalStateException ex) {
                    if (!this.logger.isLoggable(Level.FINE)) return action;
                    this.logger.fine("Continuation.complete() " + ex);
                    return action;
                }
                finally {
                    this.resumed(req, res);
                }
            }
        } else {
            if (c.isInitial() || !c.isExpired()) return action;
            this.timedout(req, res);
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        super.action(actionEvent);
        if (actionEvent.isInScope() && actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME && (this.config.getInitParameter(AtmosphereServlet.RESUME_AND_KEEPALIVE) == null || this.config.getInitParameter(AtmosphereServlet.RESUME_AND_KEEPALIVE).equalsIgnoreCase("false"))) {
            Continuation c = ContinuationSupport.getContinuation((ServletRequest)actionEvent.getRequest());
            try {
                c.complete();
                return;
            }
            catch (IllegalStateException ex) {
                if (!this.logger.isLoggable(Level.FINE)) return;
                this.logger.fine("Continuation.complete() " + ex);
                return;
            }
            finally {
                this.resumed.offer(c);
            }
        }
        try {
            actionEvent.getResponse().flushBuffer();
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

