/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.BroadcastFilterLifecycle;
import org.atmosphere.cpr.BroadcasterCache;

public class BroadcasterConfig {
    static final int numOfProcessor = Runtime.getRuntime().availableProcessors();
    protected final ConcurrentLinkedQueue<BroadcastFilter> filters = new ConcurrentLinkedQueue();
    private ExecutorService executorService;
    private ExecutorService defaultExecutorService;
    private ScheduledExecutorService scheduler;
    private final Object[] lock = new Object[0];
    private BroadcasterCache broadcasterCache;

    public BroadcasterConfig() {
        this.configExecutors();
    }

    public BroadcasterConfig(ExecutorService executorService, ScheduledExecutorService scheduler) {
        this.executorService = executorService;
        this.scheduler = scheduler;
    }

    protected void configExecutors() {
        this.defaultExecutorService = this.executorService = Executors.newCachedThreadPool(new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "Atmosphere-BroadcasterConfig-" + this.count.getAndIncrement());
            }
        });
    }

    public BroadcasterConfig setExecutorService(ExecutorService executorService) {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.executorService = executorService;
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public boolean addFilter(BroadcastFilter e) {
        if (this.filters.contains(e)) {
            return false;
        }
        if (e instanceof BroadcastFilterLifecycle) {
            ((BroadcastFilterLifecycle)e).init();
        }
        return this.filters.offer(e);
    }

    public void destroy() {
        if (this.broadcasterCache != null) {
            this.broadcasterCache.stop();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.defaultExecutorService != null) {
            this.defaultExecutorService.shutdown();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        for (BroadcastFilter f : this.filters) {
            if (!(f instanceof BroadcastFilterLifecycle)) continue;
            ((BroadcastFilterLifecycle)f).destroy();
        }
        this.removeAllFilters();
    }

    public boolean removeFilter(BroadcastFilter e) {
        if (e instanceof BroadcastFilterLifecycle) {
            ((BroadcastFilterLifecycle)e).destroy();
        }
        return this.filters.remove(e);
    }

    public void removeAllFilters() {
        for (BroadcastFilter e : this.filters) {
            this.removeFilter(e);
        }
    }

    public boolean hasFilters() {
        return !this.filters.isEmpty();
    }

    protected BroadcastFilter.BroadcastAction filter(Object object) {
        BroadcastFilter.BroadcastAction transformed = new BroadcastFilter.BroadcastAction(object);
        for (BroadcastFilter mf : this.filters) {
            transformed = mf.filter(transformed.message());
            if (transformed != null && transformed.action() != BroadcastFilter.BroadcastAction.ACTION.ABORT) continue;
            return transformed;
        }
        return transformed;
    }

    public ExecutorService getDefaultExecutorService() {
        return this.defaultExecutorService;
    }

    public BroadcasterConfig setScheduledExecutorService(ScheduledExecutorService scheduler) {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        this.scheduler = scheduler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledExecutorService getScheduledExecutorService() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            if (this.scheduler == null) {
                this.scheduler = Executors.newScheduledThreadPool(numOfProcessor);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.scheduler;
        }
    }

    public BroadcasterConfig setBroadcasterCache(BroadcasterCache broadcasterCache) {
        this.broadcasterCache = broadcasterCache;
        return this;
    }

    public BroadcasterCache getBroadcasterCache() {
        if (this.broadcasterCache == null) {
            this.broadcasterCache = new DefaultBroadcasterCache();
        }
        return this.broadcasterCache;
    }

    public static class DefaultBroadcasterCache
    implements BroadcasterCache {
        private final List<Object> list = new ArrayList<Object>();

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        public void addToCache(AtmosphereResource r, Object e) {
        }

        public List<Object> retrieveFromCache(AtmosphereResource r) {
            return this.list;
        }
    }
}

