/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.apache.catalina.CometProcessor;
import org.atmosphere.container.BlockingIOCometSupport;
import org.atmosphere.container.GoogleAppEngineCometSupport;
import org.atmosphere.container.JBossWebCometSupport;
import org.atmosphere.container.TomcatCometSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.cpr.CometSupportResolver;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.DefaultBroadcasterFactory;
import org.atmosphere.cpr.DefaultCometSupportResolver;
import org.atmosphere.cpr.WebSocketProcessor;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.util.AtmosphereConfigReader;
import org.atmosphere.util.IntrospectionUtils;
import org.atmosphere.util.LoggerUtils;
import org.atmosphere.util.Version;
import org.atmosphere.util.gae.GAEBroadcasterConfig;
import org.atmosphere.util.gae.GAEDefaultBroadcaster;
import org.atmosphere.websocket.JettyWebSocketSupport;
import org.atmosphere.websocket.WebSocketAtmosphereHandler;
import org.eclipse.jetty.websocket.WebSocket;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;
import weblogic.servlet.http.AbstractAsyncServlet;
import weblogic.servlet.http.RequestResponseKey;

public class AtmosphereServlet
extends AbstractAsyncServlet
implements CometProcessor,
HttpEventServlet {
    public static final String JERSEY_BROADCASTER = "org.atmosphere.jersey.JerseyBroadcaster";
    public static final String JERSEY_CONTAINER = "com.sun.jersey.spi.container.servlet.ServletContainer";
    public static final String GAE_BROADCASTER = GAEDefaultBroadcaster.class.getName();
    public static final String PROPERTY_SERVLET_MAPPING = "org.atmosphere.jersey.servlet-mapping";
    public static final String PROPERTY_BLOCKING_COMETSUPPORT = "org.atmosphere.useBlocking";
    public static final String PROPERTY_NATIVE_COMETSUPPORT = "org.atmosphere.useNative";
    public static final String WEBSOCKET_SUPPORT = "org.atmosphere.useWebSocket";
    public static final String PROPERTY_USE_STREAM = "org.atmosphere.useStream";
    public static final String BROADCASTER_FACTORY = "org.atmosphere.cpr.broadcasterFactory";
    public static final String BROADCASTER_CLASS = "org.atmosphere.cpr.broadcasterClass";
    public static final String BROADCASTER_CACHE = "org.atmosphere.cpr.broadcasterCacheClass";
    public static final String PROPERTY_COMET_SUPPORT = "org.atmosphere.cpr.cometSupport";
    public static final String PROPERTY_SESSION_SUPPORT = "org.atmosphere.cpr.sessionSupport";
    public static final String PRIMEFACES_SERVLET = "org.primefaces.comet.PrimeFacesCometServlet";
    public static final String DISABLE_ONSTATE_EVENT = "org.atmosphere.disableOnStateEvent";
    public static final String WEB_INF = "/WEB-INF/classes/";
    public static final String RESUME_ON_BROADCAST = "org.atmosphere.resumeOnBroadcast";
    public static final String ATMOSPHERE_SERVLET = AtmosphereServlet.class.getName();
    public static final String ATMOSPHERE_RESOURCE = AtmosphereResource.class.getName();
    public static final String SUPPORT_SESSION = "org.atmosphere.cpr.AsynchronousProcessor.supportSession";
    public static final String ATMOSPHERE_HANDLER = AtmosphereHandler.class.getName();
    public static final String WEBSOCKET_ATMOSPHEREHANDLER = WebSocketAtmosphereHandler.class.getName();
    public static final Logger logger = LoggerUtils.getLogger();
    public static final String RESUME_AND_KEEPALIVE = AtmosphereServlet.class.getName() + ".resumeAndKeepAlive";
    public static final String RESUMED_ON_TIMEOUT = AtmosphereServlet.class.getName() + ".resumedOnTimeout";
    public static final String DEFAULT_NAMED_DISPATCHER = "default";
    public static final String BROADCAST_FILTER_CLASSES = "org.atmosphere.cpr.broadcastFilterClasses";
    protected final ArrayList<String> possibleAtmosphereHandlersCandidate = new ArrayList();
    protected final HashMap<String, String> initParams = new HashMap();
    protected final AtmosphereConfig config = new AtmosphereConfig();
    protected final AtomicBoolean isCometSupportConfigured = new AtomicBoolean(false);
    protected final boolean isFilter;
    private final Map<String, AtmosphereHandlerWrapper> atmosphereHandlers = new ConcurrentHashMap<String, AtmosphereHandlerWrapper>();
    protected boolean useNativeImplementation = false;
    protected boolean useBlockingImplementation = false;
    protected boolean useStreamForFlushingComments = false;
    protected CometSupport cometSupport;
    protected static String broadcasterClassName = DefaultBroadcaster.class.getName();
    protected boolean isCometSupportSpecified = false;
    protected boolean isBroadcasterSpecified = false;
    protected boolean isSessionSupportSpecified = false;
    private BroadcasterFactory broadcasterFactory;
    private static BroadcasterConfig broadcasterConfig = new BroadcasterConfig();
    private String broadcasterCacheClassName;
    private boolean webSocketEnabled = false;

    public AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    public AtmosphereServlet() {
        this(false);
    }

    public AtmosphereServlet(boolean isFilter) {
        this.isFilter = isFilter;
        this.readSystemProperties();
    }

    public void addAtmosphereHandler(String mapping, AtmosphereHandler h) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(h);
        this.atmosphereHandlers.put(mapping, w);
    }

    public void addAtmosphereHandler(String mapping, AtmosphereHandler h, String broadcasterId) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(h);
        w.broadcaster.setID(broadcasterId);
        this.atmosphereHandlers.put(mapping, w);
    }

    public void addAtmosphereHandler(String mapping, AtmosphereHandler h, Broadcaster broadcaster) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(h, broadcaster);
        this.atmosphereHandlers.put(mapping, w);
    }

    public boolean removeAtmosphereHandler(String mapping) {
        return this.atmosphereHandlers.remove(mapping) != null;
    }

    public void removeAllAtmosphereHandler() {
        this.atmosphereHandlers.clear();
    }

    public void removeAllInitParams() {
        this.initParams.clear();
    }

    public void addInitParameter(String name, String value) {
        this.initParams.put(name, value);
    }

    protected void readSystemProperties() {
        if (System.getProperty(PROPERTY_NATIVE_COMETSUPPORT) != null) {
            this.useNativeImplementation = Boolean.parseBoolean(System.getProperty(PROPERTY_NATIVE_COMETSUPPORT));
            this.isCometSupportSpecified = true;
        }
        if (System.getProperty(PROPERTY_BLOCKING_COMETSUPPORT) != null) {
            this.useBlockingImplementation = Boolean.parseBoolean(System.getProperty(PROPERTY_BLOCKING_COMETSUPPORT));
            this.isCometSupportSpecified = true;
        }
        if (System.getProperty(DISABLE_ONSTATE_EVENT) != null) {
            this.initParams.put(DISABLE_ONSTATE_EVENT, System.getProperty(DISABLE_ONSTATE_EVENT));
        }
    }

    public void init(final ServletConfig sc) throws ServletException {
        try {
            super.init(sc);
            ServletConfig scFacade = new ServletConfig(){

                public String getServletName() {
                    return sc.getServletName();
                }

                public ServletContext getServletContext() {
                    return sc.getServletContext();
                }

                public String getInitParameter(String name) {
                    String param = sc.getInitParameter(name);
                    if (param == null) {
                        return AtmosphereServlet.this.initParams.get(name);
                    }
                    return param;
                }

                public Enumeration<String> getInitParameterNames() {
                    return sc.getInitParameterNames();
                }
            };
            this.doInitParams(scFacade);
            this.detectGoogleAppEngine(scFacade);
            this.loadConfiguration(scFacade);
            this.autoDetectContainer();
            this.configureBroadcaster();
            this.cometSupport.init(scFacade);
            this.initAtmosphereServletProcessor(scFacade);
            logger.log(Level.INFO, "Atmosphere Framework " + Version.getRawVersion() + " started.");
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "", t);
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t.getCause());
        }
    }

    protected void configureBroadcaster() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.broadcasterFactory == null) {
            this.broadcasterFactory = new DefaultBroadcasterFactory(Thread.currentThread().getContextClassLoader().loadClass(broadcasterClassName), broadcasterConfig);
            this.config.broadcasterFactory = this.broadcasterFactory;
        }
        for (Map.Entry<String, AtmosphereHandlerWrapper> e : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandlerWrapper w = e.getValue();
            if (w.broadcaster == null) {
                w.broadcaster = this.broadcasterFactory.get();
            } else {
                w.broadcaster.setBroadcasterConfig(broadcasterConfig);
            }
            w.broadcaster.setID(e.getKey());
        }
        if (this.broadcasterCacheClassName != null) {
            broadcasterConfig.setBroadcasterCache((BroadcasterCache)Thread.currentThread().getContextClassLoader().loadClass(this.broadcasterCacheClassName).newInstance());
        }
        logger.info("Using " + broadcasterClassName);
    }

    protected void doInitParams(ServletConfig sc) {
        String s = sc.getInitParameter(PROPERTY_NATIVE_COMETSUPPORT);
        if (s != null) {
            this.useNativeImplementation = Boolean.parseBoolean(s);
            if (this.useNativeImplementation) {
                this.isCometSupportSpecified = true;
            }
        }
        if ((s = sc.getInitParameter(PROPERTY_BLOCKING_COMETSUPPORT)) != null) {
            this.useBlockingImplementation = Boolean.parseBoolean(s);
            if (this.useBlockingImplementation) {
                this.isCometSupportSpecified = true;
            }
        }
        if ((s = sc.getInitParameter(PROPERTY_USE_STREAM)) != null) {
            this.useStreamForFlushingComments = Boolean.parseBoolean(s);
        }
        if ((s = sc.getInitParameter(PROPERTY_COMET_SUPPORT)) != null) {
            this.cometSupport = new DefaultCometSupportResolver(this.config).newCometSupport(s);
            this.isCometSupportSpecified = true;
        }
        if ((s = sc.getInitParameter(BROADCASTER_CLASS)) != null) {
            broadcasterClassName = s;
            this.isBroadcasterSpecified = true;
        }
        if ((s = sc.getInitParameter(BROADCASTER_CACHE)) != null) {
            this.broadcasterCacheClassName = s;
        }
        if ((s = sc.getInitParameter(PROPERTY_SESSION_SUPPORT)) != null) {
            this.config.supportSession = Boolean.valueOf(s);
            this.isSessionSupportSpecified = true;
        }
        if ((s = sc.getInitParameter(WEBSOCKET_ATMOSPHEREHANDLER)) != null) {
            this.addAtmosphereHandler("/*", new WebSocketAtmosphereHandler());
            this.webSocketEnabled = true;
            this.sessionSupport(false);
        }
        if ((s = sc.getInitParameter(WEBSOCKET_SUPPORT)) != null) {
            this.webSocketEnabled = true;
            this.sessionSupport(false);
        }
        if ((s = sc.getInitParameter(DISABLE_ONSTATE_EVENT)) != null) {
            this.initParams.put(DISABLE_ONSTATE_EVENT, s);
        } else {
            this.initParams.put(DISABLE_ONSTATE_EVENT, "false");
        }
        s = sc.getInitParameter(RESUME_AND_KEEPALIVE);
        if (s != null) {
            this.initParams.put(RESUME_AND_KEEPALIVE, s);
        }
        if ((s = sc.getInitParameter(BROADCAST_FILTER_CLASSES)) != null) {
            this.configureBroadcasterFilter(s.split(","));
        }
    }

    protected void loadConfiguration(ServletConfig sc) throws ServletException {
        try {
            URL url = sc.getServletContext().getResource(WEB_INF);
            URLClassLoader urlC = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
            this.loadAtmosphereDotXml(sc.getServletContext().getResourceAsStream("/META-INF/atmosphere.xml"), urlC);
            if (this.atmosphereHandlers.size() == 0) {
                this.autoDetectAtmosphereHandlers(sc.getServletContext(), urlC);
                if (this.atmosphereHandlers.size() == 0) {
                    this.detectSupportedFramework(sc);
                }
            }
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    void configureBroadcasterFilter(String[] list) {
        for (String broadcastFilter : list) {
            try {
                broadcasterConfig.addFilter((BroadcastFilter)BroadcastFilter.class.cast(Thread.currentThread().getContextClassLoader().loadClass(broadcastFilter).newInstance()));
            }
            catch (InstantiationException e) {
                logger.log(Level.WARNING, String.format("Error trying to instanciate BroadcastFilter %s", broadcastFilter), e);
            }
            catch (IllegalAccessException e) {
                logger.log(Level.WARNING, String.format("Error trying to instanciate BroadcastFilter %s", broadcastFilter), e);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.WARNING, String.format("Error trying to instanciate BroadcastFilter %s", broadcastFilter), e);
            }
        }
    }

    protected boolean detectSupportedFramework(ServletConfig sc) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            cl.loadClass(PRIMEFACES_SERVLET);
            return false;
        }
        catch (Throwable ignored) {
            try {
                cl.loadClass(JERSEY_CONTAINER);
                this.useStreamForFlushingComments = true;
            }
            catch (Throwable t) {
                return false;
            }
            logger.warning("Missing META-INF/atmosphere.xml but found the Jersey runtime. Starting Jersey");
            ReflectorServletProcessor rsp = new ReflectorServletProcessor();
            if (!this.isBroadcasterSpecified) {
                broadcasterClassName = JERSEY_BROADCASTER;
            }
            rsp.setServletClassName(JERSEY_CONTAINER);
            this.sessionSupport(false);
            this.initParams.put(DISABLE_ONSTATE_EVENT, "true");
            String mapping = sc.getInitParameter(PROPERTY_SERVLET_MAPPING);
            if (mapping == null) {
                mapping = "/*";
            }
            Class<?> bc = cl.loadClass(broadcasterClassName);
            Broadcaster b = (Broadcaster)bc.getDeclaredConstructor(String.class).newInstance(mapping);
            this.addAtmosphereHandler(mapping, (AtmosphereHandler)rsp, b);
            return true;
        }
    }

    protected void sessionSupport(boolean sessionSupport) {
        if (!this.isSessionSupportSpecified) {
            this.config.supportSession = sessionSupport;
        }
    }

    boolean detectGoogleAppEngine(ServletConfig sc) {
        if (sc.getServletContext().getServerInfo().startsWith("Google")) {
            broadcasterClassName = GAE_BROADCASTER;
            this.isBroadcasterSpecified = true;
            this.cometSupport = new GoogleAppEngineCometSupport(this.config);
            broadcasterConfig = new GAEBroadcasterConfig();
            return true;
        }
        return false;
    }

    void initAtmosphereServletProcessor(ServletConfig sc) throws ServletException {
        for (Map.Entry<String, AtmosphereHandlerWrapper> h : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandler a = h.getValue().atmosphereHandler;
            if (!(a instanceof AtmosphereServletProcessor)) continue;
            ((AtmosphereServletProcessor)a).init(sc);
        }
    }

    public void destroy() {
        if (this.cometSupport != null && AsynchronousProcessor.class.isAssignableFrom(this.cometSupport.getClass())) {
            ((AsynchronousProcessor)this.cometSupport).shutdown();
        }
        for (Map.Entry<String, AtmosphereHandlerWrapper> h : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandler a = h.getValue().atmosphereHandler;
            if (a instanceof AtmosphereServletProcessor) {
                ((AtmosphereServletProcessor)a).destroy();
            }
            h.getValue().broadcaster.destroy();
        }
        BroadcasterFactory.factory = null;
        BroadcasterFactory.getDefault().destroy();
        broadcasterConfig = new BroadcasterConfig();
    }

    protected void loadAtmosphereDotXml(InputStream stream, URLClassLoader c) throws IOException, ServletException {
        if (stream == null) {
            return;
        }
        AtmosphereConfigReader reader = new AtmosphereConfigReader(stream);
        Map<String, String> atmosphereHandlerNames = reader.getAtmosphereHandlers();
        Set<Map.Entry<String, String>> entries = atmosphereHandlerNames.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            try {
                String bc;
                AtmosphereHandler<HttpServletRequest, HttpServletResponse> g = !entry.getValue().equals(ReflectorServletProcessor.class.getName()) ? (AtmosphereHandler)c.loadClass(entry.getValue()).newInstance() : new ReflectorServletProcessor();
                logger.info("Sucessfully loaded " + g + " mapped to context-path " + entry.getKey());
                AtmosphereHandlerWrapper wrapper = new AtmosphereHandlerWrapper(g);
                this.atmosphereHandlers.put(entry.getKey(), wrapper);
                boolean isJersey = false;
                for (AtmosphereConfigReader.Property p : reader.getProperty(entry.getKey())) {
                    if (p.value != null && p.value.indexOf("jersey") != -1) {
                        isJersey = true;
                        this.initParams.put(DISABLE_ONSTATE_EVENT, "true");
                        this.useStreamForFlushingComments = true;
                    }
                    IntrospectionUtils.setProperty(g, p.name, p.value);
                }
                this.config.supportSession = !isJersey;
                if (!reader.supportSession().equals("")) {
                    this.sessionSupport(Boolean.valueOf(reader.supportSession()));
                }
                for (AtmosphereConfigReader.Property p : reader.getProperty(entry.getKey())) {
                    IntrospectionUtils.addProperty(g, p.name, p.value);
                }
                String broadcasterClass = reader.getBroadcasterClass(entry.getKey());
                if (broadcasterClass != null) {
                    broadcasterClassName = broadcasterClass;
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> bc2 = cl.loadClass(broadcasterClassName);
                    wrapper.broadcaster = BroadcasterFactory.getDefault().get(bc2, entry.getKey());
                }
                if ((bc = reader.getBroadcasterCache(entry.getKey())) != null) {
                    this.broadcasterCacheClassName = bc;
                }
                if (reader.getCometSupportClass() != null) {
                    this.cometSupport = (CometSupport)c.loadClass(reader.getCometSupportClass()).newInstance();
                }
                if (reader.getBroadcastFilterClasses() == null) continue;
                this.configureBroadcasterFilter(reader.getBroadcastFilterClasses());
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Unable to load AtmosphereHandler class: " + entry.getValue(), t);
                throw new ServletException(t);
            }
        }
    }

    public void setCometSupport(CometSupport cometSupport) {
        this.cometSupport = cometSupport;
    }

    public CometSupport getCometSupport() {
        return this.cometSupport;
    }

    protected CometSupportResolver createCometSupportResolver() {
        return new DefaultCometSupportResolver(this.config);
    }

    protected void autoDetectContainer() {
        if (this.getCometSupport() == null) {
            this.setCometSupport(this.createCometSupportResolver().resolve(this.useNativeImplementation, this.useBlockingImplementation, this.webSocketEnabled));
        }
        logger.info("Atmosphere is using for CometSupport: " + this.getCometSupport().getClass().getName() + " running under container " + this.cometSupport.getContainerName());
    }

    protected void autoDetectAtmosphereHandlers(ServletContext sc, URLClassLoader c) throws MalformedURLException, URISyntaxException {
        File f;
        String s = sc.getRealPath(WEB_INF);
        if (s == null) {
            URL u = sc.getResource(WEB_INF);
            if (u == null) {
                return;
            }
            s = u.getPath();
        }
        if ((f = new File(s)).isDirectory()) {
            this.getFiles(f);
            for (String className : this.possibleAtmosphereHandlersCandidate) {
                try {
                    className = className.replace('\\', '/');
                    Class<?> clazz = c.loadClass(className = className.substring(className.indexOf(WEB_INF) + WEB_INF.length(), className.lastIndexOf(".")).replace('/', '.'));
                    if (!AtmosphereHandler.class.isAssignableFrom(clazz)) continue;
                    AtmosphereHandler g = (AtmosphereHandler)clazz.newInstance();
                    logger.info("Successfully loaded " + g + " mapped to context-path " + g.getClass().getSimpleName());
                    this.atmosphereHandlers.put("/" + g.getClass().getSimpleName(), new AtmosphereHandlerWrapper(g, null));
                }
                catch (Throwable t) {
                    logger.finest(className + " is not a AtmosphereHandler");
                }
            }
        }
        logger.info("Atmosphere using Broadcaster " + broadcasterClassName);
    }

    protected void getFiles(File f) {
        File[] files;
        for (File test : files = f.listFiles()) {
            if (test.isDirectory()) {
                this.getFiles(test);
                continue;
            }
            String clazz = test.getAbsolutePath();
            if (!clazz.endsWith(".class")) continue;
            this.possibleAtmosphereHandlersCandidate.add(clazz);
        }
    }

    public void doHead(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doOptions(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doTrace(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doCometSupport(req, res);
    }

    protected Action doCometSupport(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        req.setAttribute(BROADCASTER_FACTORY, (Object)this.broadcasterFactory);
        req.setAttribute(PROPERTY_USE_STREAM, (Object)this.useStreamForFlushingComments);
        try {
            return this.cometSupport.service(req, res);
        }
        catch (IllegalStateException ex) {
            if (ex.getMessage() != null && ex.getMessage().startsWith("Tomcat failed")) {
                if (!this.isFilter) {
                    logger.warning(ex.getMessage());
                    logger.warning("Using the BlockingIOCometSupport.");
                }
            } else {
                logger.log(Level.SEVERE, "AtmosphereServlet exception", ex);
                throw ex;
            }
            this.cometSupport = new BlockingIOCometSupport(this.config);
            this.service(req, res);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(CometEvent cometEvent) throws IOException, ServletException {
        HttpServletRequest req = cometEvent.getHttpServletRequest();
        HttpServletResponse res = cometEvent.getHttpServletResponse();
        req.setAttribute("CometEvent", (Object)cometEvent);
        if (!this.isCometSupportSpecified && !this.isCometSupportConfigured.getAndSet(true)) {
            CometSupport cometSupport = this.cometSupport;
            synchronized (cometSupport) {
                if (!this.cometSupport.getClass().equals(TomcatCometSupport.class)) {
                    logger.warning("TomcatCometSupport is enabled, switching to it");
                    this.cometSupport = new TomcatCometSupport(this.config);
                }
            }
        }
        this.doCometSupport(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(HttpEvent httpEvent) throws IOException, ServletException {
        HttpServletRequest req = httpEvent.getHttpServletRequest();
        HttpServletResponse res = httpEvent.getHttpServletResponse();
        req.setAttribute("HttpEvent", (Object)httpEvent);
        if (!this.isCometSupportSpecified && !this.isCometSupportConfigured.getAndSet(true)) {
            CometSupport cometSupport = this.cometSupport;
            synchronized (cometSupport) {
                if (!this.cometSupport.getClass().equals(JBossWebCometSupport.class)) {
                    logger.warning("JBossWebCometSupport is enabled, switching to it");
                    this.cometSupport = new JBossWebCometSupport(this.config);
                }
            }
        }
        this.doCometSupport(req, res);
    }

    protected boolean doRequest(RequestResponseKey rrk) throws IOException, ServletException {
        try {
            rrk.getRequest().getSession().setAttribute("RequestResponseKey", (Object)rrk);
            Action action = this.doCometSupport(rrk.getRequest(), rrk.getResponse());
            if (action.type == Action.TYPE.SUSPEND) {
                if (action.timeout == -1L) {
                    rrk.setTimeout(Integer.MAX_VALUE);
                } else {
                    rrk.setTimeout((int)action.timeout);
                }
            }
            return action.type == Action.TYPE.SUSPEND;
        }
        catch (IllegalStateException ex) {
            logger.log(Level.SEVERE, "AtmosphereServlet.doRequest exception", ex);
            throw ex;
        }
    }

    protected void doResponse(RequestResponseKey rrk, Object context) throws IOException, ServletException {
        rrk.getResponse().flushBuffer();
    }

    protected void doTimeout(RequestResponseKey rrk) throws IOException, ServletException {
        ((AsynchronousProcessor)this.cometSupport).timedout(rrk.getRequest(), rrk.getResponse());
    }

    public static String getDefaultBroadcasterClassName() {
        return broadcasterClassName;
    }

    public static void setDefaultBroadcasterClassName(String broadcasterClassName) {
    }

    public boolean isUseStreamForFlushingComments() {
        return this.useStreamForFlushingComments;
    }

    public void setUseStreamForFlushingComments(boolean useStreamForFlushingComments) {
        this.useStreamForFlushingComments = useStreamForFlushingComments;
    }

    public BroadcasterFactory getBroadcasterFactory() {
        return this.broadcasterFactory;
    }

    public AtmosphereServlet setBroadcasterFactory(BroadcasterFactory broadcasterFactory) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this.broadcasterFactory = broadcasterFactory;
        this.configureBroadcaster();
        return this;
    }

    public static BroadcasterConfig getBroadcasterConfig() {
        return broadcasterConfig;
    }

    public String getBroadcasterCacheClassName() {
        return this.broadcasterCacheClassName;
    }

    public void setBroadcasterCacheClassName(String broadcasterCacheClassName) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this.broadcasterCacheClassName = broadcasterCacheClassName;
        this.configureBroadcaster();
    }

    protected WebSocket doWebSocketConnect(final HttpServletRequest request, String protocol) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("WebSocket upgrade requested");
        }
        return new WebSocket(){
            private WebSocketProcessor webSocketProcessor;

            public void onConnect(WebSocket.Outbound outbound) {
                this.webSocketProcessor = new WebSocketProcessor(AtmosphereServlet.this, new JettyWebSocketSupport(outbound));
                try {
                    this.webSocketProcessor.connect(request);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "", e);
                }
            }

            public void onMessage(byte frame, String data) {
                this.webSocketProcessor.broadcast(frame, data);
            }

            public void onMessage(byte frame, byte[] data, int offset, int length) {
                this.webSocketProcessor.broadcast(frame, new String(data, offset, length));
            }

            public void onDisconnect() {
                this.webSocketProcessor.close();
            }
        };
    }

    public static class Action {
        public long timeout = -1L;
        public TYPE type;

        public Action() {
            this.type = TYPE.CANCELLED;
        }

        public Action(TYPE type) {
            this.type = type;
        }

        public Action(TYPE type, long timeout) {
            this.timeout = timeout;
            this.type = type;
        }

        public static enum TYPE {
            SUSPEND,
            RESUME,
            TIMEOUT,
            CANCELLED,
            KEEP_ALIVED;

        }
    }

    public class AtmosphereConfig {
        private boolean supportSession = true;
        private BroadcasterFactory broadcasterFactory;
        private String dispatcherName = "default";

        protected Map<String, AtmosphereHandlerWrapper> handlers() {
            return AtmosphereServlet.this.atmosphereHandlers;
        }

        public ServletContext getServletContext() {
            return AtmosphereServlet.this.getServletContext();
        }

        public String getDispatcherName() {
            return this.dispatcherName;
        }

        public void setDispatcherName(String dispatcherName) {
            this.dispatcherName = dispatcherName;
        }

        public String getInitParameter(String name) {
            String s = AtmosphereServlet.this.initParams.get(name);
            if (s != null) {
                return s;
            }
            return AtmosphereServlet.this.getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return AtmosphereServlet.this.getInitParameterNames();
        }

        public ServletConfig getServletConfig() {
            return AtmosphereServlet.this.getServletConfig();
        }

        public String getWebServerName() {
            return AtmosphereServlet.this.cometSupport.getContainerName();
        }

        public boolean mapBroadcasterToAtmosphereHandler(Broadcaster bc, AtmosphereHandlerWrapper ahw) {
            if (AtmosphereServlet.this.atmosphereHandlers.get(bc.getID()) == null) {
                AtmosphereServlet.this.atmosphereHandlers.put(bc.getID(), ahw);
                return true;
            }
            return false;
        }

        public AtmosphereHandler getAtmosphereHandler(Broadcaster bc) {
            AtmosphereHandler h = ((AtmosphereHandlerWrapper)((AtmosphereServlet)AtmosphereServlet.this).atmosphereHandlers.get((Object)bc.getID())).atmosphereHandler;
            if (h == null) {
                for (AtmosphereHandlerWrapper ah : AtmosphereServlet.this.atmosphereHandlers.values()) {
                    if (ah.broadcaster != bc) continue;
                    AtmosphereServlet.this.atmosphereHandlers.put(bc.getID(), ah);
                    return ah.atmosphereHandler;
                }
                throw new IllegalStateException("Unable to find associated AtmosphereHandler");
            }
            return h;
        }

        public BroadcasterFactory getBroadcasterFactory() {
            return this.broadcasterFactory;
        }

        public boolean isSupportSession() {
            return this.supportSession;
        }

        public void setSupportSession(boolean supportSession) {
            this.supportSession = supportSession;
        }

        public AtmosphereServlet getServlet() {
            return AtmosphereServlet.this;
        }
    }

    public static final class AtmosphereHandlerWrapper {
        public final AtmosphereHandler atmosphereHandler;
        public Broadcaster broadcaster;

        public AtmosphereHandlerWrapper(AtmosphereHandler atmosphereHandler) {
            this.atmosphereHandler = atmosphereHandler;
            try {
                this.broadcaster = BroadcasterFactory.getDefault().get();
            }
            catch (Exception t) {
                throw new RuntimeException(t);
            }
        }

        public AtmosphereHandlerWrapper(AtmosphereHandler atmosphereHandler, Broadcaster broadcaster) {
            this.atmosphereHandler = atmosphereHandler;
            this.broadcaster = broadcaster;
        }
    }
}

