/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.BlockingIOCometSupport;
import org.atmosphere.cpr.AtmosphereServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleAppEngineCometSupport
extends BlockingIOCometSupport {
    private static final Logger logger = LoggerFactory.getLogger(GoogleAppEngineCometSupport.class);

    public GoogleAppEngineCometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void suspend(AtmosphereServlet.Action action, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        CountDownLatch latch = new CountDownLatch(1);
        req.setAttribute("org.atmosphere.container.BlockingIOCometSupport.latch", (Object)latch.hashCode());
        this.latchs.put(latch.hashCode(), latch);
        if (this.supportSession()) {
            req.getSession().setAttribute("org.atmosphere.container.BlockingIOCometSupport.latch", (Object)latch.hashCode());
        }
        try {
            if (action.timeout != -1L && action.timeout < 30000L) {
                latch.await(action.timeout, TimeUnit.MILLISECONDS);
            } else {
                latch.await(20000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable ex) {
            logger.warn("Unable to resume the suspended connection", ex);
        }
        finally {
            try {
                this.timedout(req, res);
            }
            catch (Throwable e) {
                logger.warn("Unable to timeout connection", e);
            }
        }
    }
}

