/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereEventLifecycle;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereResourceImpl
implements AtmosphereResource<HttpServletRequest, HttpServletResponse>,
AtmosphereEventLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereResourceImpl.class);
    public static final String PRE_SUSPEND = AtmosphereResourceImpl.class.getName() + ".preSuspend";
    private final HttpServletRequest req;
    private final HttpServletResponse response;
    protected final AtmosphereServlet.Action action = new AtmosphereServlet.Action();
    protected Broadcaster broadcaster;
    private final AtmosphereServlet.AtmosphereConfig config;
    protected final CometSupport cometSupport;
    private Serializer serializer;
    private boolean isInScope = true;
    private final AtmosphereResourceEventImpl event;
    private static final String beginCompatibleData = AtmosphereResourceImpl.createCompatibleStringJunk();
    private boolean useWriter = true;
    private final ConcurrentLinkedQueue<AtmosphereResourceEventListener> listeners = new ConcurrentLinkedQueue();
    private final boolean injectCacheHeaders;
    private final boolean enableAccessControl;
    private final AtomicBoolean isSuspendEvent = new AtomicBoolean(false);
    private final AtmosphereHandler atmosphereHandler;

    public AtmosphereResourceImpl(AtmosphereServlet.AtmosphereConfig config, Broadcaster broadcaster, HttpServletRequest req, HttpServletResponse response, CometSupport cometSupport, AtmosphereHandler atmosphereHandler) {
        this.req = req;
        this.response = response;
        this.broadcaster = broadcaster;
        this.config = config;
        this.cometSupport = cometSupport;
        this.atmosphereHandler = atmosphereHandler;
        this.event = new AtmosphereResourceEventImpl(this);
        String nocache = config.getInitParameter("org.atmosphere.cpr.noCacheHeaders");
        this.injectCacheHeaders = nocache == null;
        String ac = config.getInitParameter("org.atmosphere.cpr.dropAccessControlAllowOriginHeader");
        this.enableAccessControl = ac == null;
    }

    @Override
    public AtmosphereResourceEventImpl getAtmosphereResourceEvent() {
        return this.event;
    }

    @Override
    public AtmosphereHandler getAtmosphereHandler() {
        return this.atmosphereHandler;
    }

    @Override
    public void resume() {
        if (!this.event.isResuming() && !this.event.isResumedOnTimeout() && this.event.isSuspended() && this.isInScope) {
            this.action.type = AtmosphereServlet.Action.TYPE.RESUME;
            Broadcaster b = this.getBroadcaster();
            if (b instanceof DefaultBroadcaster) {
                ((DefaultBroadcaster)b).broadcastOnResume(this);
            }
            this.notifyListeners();
            this.listeners.clear();
            this.broadcaster.removeAtmosphereResource(this);
            BroadcasterFactory.getDefault().removeAllAtmosphereResource(this);
            try {
                this.req.setAttribute(AtmosphereServlet.RESUMED_ON_TIMEOUT, (Object)Boolean.FALSE);
            }
            catch (Exception ex) {
                logger.debug("Cannot resume an already resumed/cancelled request");
            }
            this.cometSupport.action(this);
        } else {
            logger.debug("Cannot resume an already resumed/cancelled request");
        }
    }

    @Override
    public void suspend() {
        this.suspend(-1L);
    }

    @Override
    public void suspend(long timeout) {
        this.suspend(timeout, true);
    }

    @Override
    public void suspend(long timeout, boolean flushComment) {
        if (this.req.getSession(false) != null && this.req.getSession().getMaxInactiveInterval() != -1 && (long)(this.req.getSession().getMaxInactiveInterval() * 1000) < timeout) {
            throw new IllegalStateException("Cannot suspend a response longer than the session timeout. Increase the value of session-timeout in web.xml");
        }
        if (!this.event.isResumedOnTimeout()) {
            String upgrade = this.req.getHeader("Connection");
            if (upgrade != null && upgrade.equalsIgnoreCase("Upgrade")) {
                if (!this.cometSupport.supportWebSocket()) {
                    this.response.addHeader("X-Atmosphere-error", "Websocket protocol not supported");
                } else {
                    flushComment = false;
                }
            }
            if (this.injectCacheHeaders) {
                this.response.setHeader("Expires", "-1");
                this.response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
                this.response.setHeader("Pragma", "no-cache");
            }
            if (this.enableAccessControl) {
                this.response.setHeader("Access-Control-Allow-Origin", "*");
            }
            if (flushComment) {
                this.write();
            }
            this.req.setAttribute(PRE_SUSPEND, (Object)"true");
            this.action.type = AtmosphereServlet.Action.TYPE.SUSPEND;
            this.action.timeout = timeout;
            if (this.broadcaster.getScope() == Broadcaster.SCOPE.REQUEST) {
                String id = this.broadcaster.getID();
                Class<?> clazz = this.broadcaster.getClass();
                this.broadcaster = BroadcasterFactory.getDefault().lookup(clazz, id, false);
                if (this.broadcaster == null || this.broadcaster.getAtmosphereResources().size() > 0) {
                    this.broadcaster = BroadcasterFactory.getDefault().lookup(clazz, id + "/" + UUID.randomUUID(), true);
                }
            }
            this.broadcaster.addAtmosphereResource(this);
            this.req.removeAttribute(PRE_SUSPEND);
            this.notifyListeners();
        }
    }

    void write() {
        block7: {
            try {
                if (this.useWriter && !((Boolean)this.req.getAttribute("org.atmosphere.useStream")).booleanValue()) {
                    try {
                        this.response.getWriter();
                    }
                    catch (IllegalStateException e) {
                        return;
                    }
                    this.response.getWriter().write(beginCompatibleData);
                    this.response.getWriter().flush();
                    break block7;
                }
                try {
                    this.response.getOutputStream();
                }
                catch (IllegalStateException e) {
                    return;
                }
                this.response.getOutputStream().write(beginCompatibleData.getBytes());
                this.response.getOutputStream().flush();
            }
            catch (Throwable ex) {
                logger.warn("failed to write to response", ex);
            }
        }
    }

    @Override
    public HttpServletRequest getRequest() {
        if (!this.isInScope) {
            throw new IllegalStateException("Request object no longer valid. This object has been cancelled");
        }
        return this.req;
    }

    @Override
    public HttpServletResponse getResponse() {
        if (!this.isInScope) {
            throw new IllegalStateException("Response object no longer valid. This object has been cancelled");
        }
        return this.response;
    }

    @Override
    public Broadcaster getBroadcaster() {
        if (this.broadcaster == null) {
            throw new IllegalStateException("No Broadcaster associated with this AtmosphereResource.");
        }
        return this.broadcaster;
    }

    @Override
    public void setBroadcaster(Broadcaster broadcaster) {
        this.broadcaster = broadcaster;
        if (broadcaster != null) {
            broadcaster.getBroadcasterConfig().setAtmosphereConfig(this.config);
        }
    }

    @Override
    public AtmosphereServlet.AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    public AtmosphereServlet.Action action() {
        return this.action;
    }

    protected void setIsInScope(boolean isInScope) {
        this.isInScope = isInScope;
    }

    public boolean isInScope() {
        return this.isInScope;
    }

    @Override
    public void setSerializer(Serializer s) {
        this.serializer = s;
    }

    @Override
    public void write(OutputStream os, Object o) throws IOException {
        if (o == null) {
            throw new IllegalStateException("Object cannot be null");
        }
        if (this.serializer != null) {
            this.serializer.write(os, o);
        } else {
            this.response.getOutputStream().write(o.toString().getBytes());
        }
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }

    public static String createCompatibleStringJunk() {
        StringBuilder s = new StringBuilder();
        s.append("<!-- ---------------------------------------------------------------- http://github.com/Atmosphere ------------------------------------------------------------------------ -->\n");
        s.append("<!-- Welcome to the Atmosphere Framework. To work with all the browsers when suspending connection, Atmosphere must output some data to makes WebKit based browser working.-->\n");
        for (int i = 0; i < 10; ++i) {
            s.append("<!-- --------------------------------------------------------------------------------------------------------------------------------------------------------------------- -->\n");
        }
        s.append("<!-- EOD -->");
        return s.toString();
    }

    @Override
    public void addEventListener(AtmosphereResourceEventListener e) {
        if (this.listeners.contains(e)) {
            return;
        }
        this.listeners.add(e);
    }

    @Override
    public void removeEventListener(AtmosphereResourceEventListener e) {
        this.listeners.remove(e);
    }

    @Override
    public void removeEventListeners() {
        this.listeners.clear();
    }

    @Override
    public void notifyListeners() {
        this.notifyListeners(this.event);
    }

    @Override
    public void notifyListeners(AtmosphereResourceEvent event) {
        if (event.isResuming() || event.isResumedOnTimeout()) {
            this.onResume(event);
        } else if (event.isCancelled()) {
            this.onDisconnect(event);
        } else if (!this.isSuspendEvent.getAndSet(true) && event.isSuspended()) {
            this.onSuspend(event);
        } else if (event.throwable() != null) {
            this.onThrowable(event);
        } else {
            this.onBroadcast(event);
        }
    }

    public void onThrowable(Throwable t) {
        this.onThrowable(new AtmosphereResourceEventImpl(this, false, false, t));
    }

    void onThrowable(AtmosphereResourceEvent e) {
        AtmosphereHandler atmosphereHandler = (AtmosphereHandler)this.req.getAttribute(AtmosphereServlet.ATMOSPHERE_HANDLER);
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onThrowable(e);
        }
    }

    void onSuspend(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onSuspend(e);
        }
    }

    void onResume(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onResume(e);
        }
    }

    void onDisconnect(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onDisconnect(e);
        }
    }

    void onBroadcast(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onBroadcast(e);
        }
    }

    public String toString() {
        return "AtmosphereResourceImpl{, action=" + this.action + ", broadcaster=" + this.broadcaster.getClass().getName() + ", cometSupport=" + this.cometSupport + ", serializer=" + this.serializer + ", isInScope=" + this.isInScope + ", useWriter=" + this.useWriter + ", listeners=" + this.listeners + '}';
    }
}

