/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.BroadcastFilterLifecycle;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.PerRequestBroadcastFilter;
import org.atmosphere.di.InjectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcasterConfig {
    private static final Logger logger = LoggerFactory.getLogger(BroadcasterConfig.class);
    protected final ConcurrentLinkedQueue<BroadcastFilter> filters = new ConcurrentLinkedQueue();
    protected final ConcurrentLinkedQueue<PerRequestBroadcastFilter> perRequestFilters = new ConcurrentLinkedQueue();
    private ExecutorService executorService;
    private ExecutorService asyncWriteService;
    private ExecutorService defaultExecutorService;
    private ExecutorService defaultAsyncWriteService;
    private ScheduledExecutorService scheduler;
    private final Object[] lock = new Object[0];
    private BroadcasterCache broadcasterCache;
    private AtmosphereServlet.AtmosphereConfig config;

    public BroadcasterConfig(String[] list, AtmosphereServlet.AtmosphereConfig config) {
        this.config = config;
        this.configExecutors();
        this.configureBroadcasterFilter(list);
        this.configureBroadcasterCache();
    }

    private void configureBroadcasterCache() {
        try {
            if (AtmosphereServlet.broadcasterCacheClassName != null) {
                BroadcasterCache cache = (BroadcasterCache)Thread.currentThread().getContextClassLoader().loadClass(AtmosphereServlet.broadcasterCacheClassName).newInstance();
                InjectorProvider.getInjector().inject(cache);
                this.setBroadcasterCache(cache);
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public BroadcasterConfig(ExecutorService executorService, ExecutorService asyncWriteService, ScheduledExecutorService scheduler, AtmosphereServlet.AtmosphereConfig config) {
        this.executorService = executorService;
        this.scheduler = scheduler;
        this.asyncWriteService = asyncWriteService;
        this.config = config;
    }

    protected void configExecutors() {
        this.defaultExecutorService = this.executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "Atmosphere-BroadcasterConfig-" + this.count.getAndIncrement());
            }
        });
        this.defaultAsyncWriteService = this.asyncWriteService = Executors.newCachedThreadPool(new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "Atmosphere-AsyncWrite-" + this.count.getAndIncrement());
            }
        });
    }

    public BroadcasterConfig setExecutorService(ExecutorService executorService) {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.executorService = executorService;
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public BroadcasterConfig setAsyncWriteService(ExecutorService asyncWriteService) {
        if (this.asyncWriteService != null) {
            this.asyncWriteService.shutdown();
        }
        this.asyncWriteService = asyncWriteService;
        return this;
    }

    public ExecutorService getAsyncWriteService() {
        return this.asyncWriteService;
    }

    public boolean addFilter(BroadcastFilter e) {
        if (this.filters.contains(e) || this.checkDuplicateFilter(e)) {
            return false;
        }
        if (e instanceof BroadcastFilterLifecycle) {
            ((BroadcastFilterLifecycle)e).init();
        }
        if (e instanceof PerRequestBroadcastFilter) {
            this.perRequestFilters.add((PerRequestBroadcastFilter)e);
        }
        return this.filters.offer(e);
    }

    private boolean checkDuplicateFilter(BroadcastFilter e) {
        for (BroadcastFilter f : this.filters) {
            if (!f.getClass().isAssignableFrom(e.getClass())) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        if (this.broadcasterCache != null) {
            this.broadcasterCache.stop();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.asyncWriteService != null) {
            this.asyncWriteService.shutdown();
        }
        if (this.defaultExecutorService != null) {
            this.defaultExecutorService.shutdown();
        }
        if (this.defaultAsyncWriteService != null) {
            this.defaultAsyncWriteService.shutdown();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        for (BroadcastFilter f : this.filters) {
            if (!(f instanceof BroadcastFilterLifecycle)) continue;
            ((BroadcastFilterLifecycle)f).destroy();
        }
        this.removeAllFilters();
    }

    public boolean removeFilter(BroadcastFilter filter) {
        if (filter instanceof BroadcastFilterLifecycle) {
            ((BroadcastFilterLifecycle)filter).destroy();
        }
        if (filter instanceof PerRequestBroadcastFilter) {
            this.perRequestFilters.remove(filter);
        }
        return this.filters.remove(filter);
    }

    public void removeAllFilters() {
        for (BroadcastFilter filter : this.filters) {
            this.removeFilter(filter);
        }
    }

    public boolean hasFilters() {
        return !this.filters.isEmpty();
    }

    public boolean hasPerRequestFilters() {
        if (this.filters.isEmpty()) {
            return false;
        }
        for (BroadcastFilter b : this.filters) {
            if (!PerRequestBroadcastFilter.class.isAssignableFrom(b.getClass())) continue;
            return true;
        }
        return false;
    }

    protected BroadcastFilter.BroadcastAction filter(Object object) {
        BroadcastFilter.BroadcastAction transformed = new BroadcastFilter.BroadcastAction(object);
        for (BroadcastFilter mf : this.filters) {
            transformed = mf.filter(object, transformed.message());
            if (transformed != null && transformed.action() != BroadcastFilter.BroadcastAction.ACTION.ABORT) continue;
            return transformed;
        }
        return transformed;
    }

    protected BroadcastFilter.BroadcastAction filter(HttpServletRequest request, HttpServletResponse response, Object object) {
        BroadcastFilter.BroadcastAction transformed = new BroadcastFilter.BroadcastAction(object);
        for (PerRequestBroadcastFilter mf : this.perRequestFilters) {
            transformed = mf.filter(request, response, transformed.message());
            if (transformed != null && transformed.action() != BroadcastFilter.BroadcastAction.ACTION.ABORT) continue;
            return transformed;
        }
        return transformed;
    }

    public ExecutorService getDefaultExecutorService() {
        return this.defaultExecutorService;
    }

    public BroadcasterConfig setScheduledExecutorService(ScheduledExecutorService scheduler) {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        this.scheduler = scheduler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledExecutorService getScheduledExecutorService() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            if (this.scheduler == null) {
                this.scheduler = Executors.newSingleThreadScheduledExecutor();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.scheduler;
        }
    }

    public BroadcasterConfig setBroadcasterCache(BroadcasterCache broadcasterCache) {
        this.broadcasterCache = broadcasterCache;
        return this;
    }

    public BroadcasterCache getBroadcasterCache() {
        if (this.broadcasterCache == null) {
            this.broadcasterCache = new DefaultBroadcasterCache();
        }
        return this.broadcasterCache;
    }

    void configureBroadcasterFilter(String[] list) {
        for (String broadcastFilter : list) {
            try {
                BroadcastFilter bf = (BroadcastFilter)BroadcastFilter.class.cast(Thread.currentThread().getContextClassLoader().loadClass(broadcastFilter).newInstance());
                InjectorProvider.getInjector().inject(bf);
                this.addFilter(bf);
            }
            catch (InstantiationException e) {
                logger.warn("Error trying to instantiate BroadcastFilter: " + broadcastFilter, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.warn("Error trying to instantiate BroadcastFilter: " + broadcastFilter, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Error trying to instantiate BroadcastFilter: " + broadcastFilter, (Throwable)e);
            }
        }
    }

    public AtmosphereServlet.AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    public void setAtmosphereConfig(AtmosphereServlet.AtmosphereConfig config) {
        this.config = config;
    }

    public static class DefaultBroadcasterCache
    implements BroadcasterCache {
        private final List<Object> list = new ArrayList<Object>();

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        public void addToCache(AtmosphereResource r, Object e) {
        }

        public List<Object> retrieveFromCache(AtmosphereResource r) {
            return this.list;
        }
    }
}

