/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.Servlet30CometSupport;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.websocket.JettyWebSocketHandler;
import org.atmosphere.websocket.WebSocketSupport;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Servlet30CometSupportWithWebSocket
extends Servlet30CometSupport {
    private static final Logger logger = LoggerFactory.getLogger(Servlet30CometSupportWithWebSocket.class);
    private final WebSocketFactory webSocketFactory;

    public Servlet30CometSupportWithWebSocket(final AtmosphereServlet.AtmosphereConfig config) {
        super(config);
        boolean isJetty = config.getServletContext().getServerInfo().toLowerCase().startsWith("jetty");
        if (isJetty) {
            String[] jettyVersion = config.getServletContext().getServerInfo().substring(6).split("\\.");
            if (Integer.valueOf(jettyVersion[0]) > 7 || Integer.valueOf(jettyVersion[0]) == 7 && Integer.valueOf(jettyVersion[1]) > 4) {
                this.webSocketFactory = new WebSocketFactory(new WebSocketFactory.Acceptor(){

                    public boolean checkOrigin(HttpServletRequest request, String origin) {
                        logger.debug("WebSocket-checkOrigin request {} with origin {}", (Object)request.getRequestURI(), (Object)origin);
                        return true;
                    }

                    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
                        logger.debug("WebSocket-connect request {} with protocol {}", (Object)request.getRequestURI(), (Object)protocol);
                        return new JettyWebSocketHandler(request, config.getServlet(), config.getServlet().getWebSocketProcessorClassName());
                    }
                });
                this.webSocketFactory.setBufferSize(4096);
                this.webSocketFactory.setMaxIdleTime(60000);
            } else {
                this.webSocketFactory = null;
            }
        } else {
            this.webSocketFactory = null;
        }
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Boolean b;
        boolean webSocketEnabled = false;
        if (req.getHeaders("Connection") != null && req.getHeaders("Connection").hasMoreElements()) {
            String[] e;
            for (String upgrade : e = ((String)req.getHeaders("Connection").nextElement()).split(",")) {
                if (!upgrade.trim().equalsIgnoreCase("Upgrade")) continue;
                webSocketEnabled = true;
                break;
            }
        }
        if ((b = (Boolean)req.getAttribute(WebSocketSupport.WEBSOCKET_INITIATED)) == null) {
            b = Boolean.FALSE;
        }
        if (!webSocketEnabled) {
            return super.service(req, res);
        }
        if (this.webSocketFactory != null && !b.booleanValue()) {
            req.setAttribute(WebSocketSupport.WEBSOCKET_INITIATED, (Object)true);
            this.webSocketFactory.acceptWebSocket(req, res);
            return new AtmosphereServlet.Action();
        }
        AtmosphereServlet.Action action = this.suspended(req, res);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            logger.debug("Suspending response: {}", (Object)res);
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            logger.debug("Resume response: {}", (Object)res);
            req.setAttribute(WebSocketSupport.WEBSOCKET_RESUME, (Object)true);
        }
        return action;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }
}

