/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.client;

import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.PerRequestBroadcastFilter;

public class JavascriptClientFilter
implements PerRequestBroadcastFilter {
    private final AtomicInteger uniqueScriptToken = new AtomicInteger();

    @Override
    public BroadcastFilter.BroadcastAction filter(Object originalMessage, Object message) {
        return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.CONTINUE, message);
    }

    @Override
    public BroadcastFilter.BroadcastAction filter(HttpServletRequest request, HttpServletResponse response, Object message) {
        String transport;
        String userAgent = request.getHeader("User-Agent") == null ? "" : request.getHeader("User-Agent").toLowerCase();
        String string = transport = request.getHeader("X-Atmosphere-Transport") == null ? "streaming" : request.getHeader("X-Atmosphere-Transport").toString();
        if (transport.equals("streaming") && userAgent.startsWith("opera")) {
            StringBuilder sb = new StringBuilder("<script id=\"atmosphere_").append(this.uniqueScriptToken.getAndIncrement()).append("\">").append("window.parent.$.atmosphere.streamingCallback").append("('").append(message.toString()).append("');</script>");
            message = sb.toString();
            return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.CONTINUE, message);
        }
        return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.CONTINUE, message);
    }
}

