/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class AtmosphereRequest
extends HttpServletRequestWrapper {
    private final ByteInputStream bis;
    private final BufferedReader br;
    private final String pathInfo;
    private final Map<String, String> headers;
    private final String methodType;
    private final String contentType;
    private final HttpServletRequest request;

    private AtmosphereRequest(Builder b) {
        super(b.request);
        this.pathInfo = b.pathInfo == null ? b.request.getPathInfo() : b.pathInfo;
        this.request = b.request;
        this.headers = b.headers;
        if (b.dataBytes != null) {
            this.bis = new ByteInputStream(b.dataBytes, b.offset, b.length);
            try {
                this.br = new BufferedReader(new StringReader(new String(b.dataBytes, b.offset, b.length, b.encoding)));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        } else if (b.data != null) {
            this.bis = new ByteInputStream(b.data.getBytes(), 0, b.data.getBytes().length);
            this.br = new BufferedReader(new StringReader(b.data));
        } else {
            this.bis = null;
            this.br = null;
        }
        this.methodType = b.methodType == null ? b.request.getMethod() : b.methodType;
        this.contentType = b.contentType == null ? b.request.getContentType() : b.contentType;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getMethod() {
        return this.methodType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Enumeration getHeaders(String name) {
        ArrayList list = Collections.list(super.getHeaders(name));
        if (name.equalsIgnoreCase("content-type")) {
            list.add(this.contentType);
        }
        if (this.headers.get(name) != null) {
            list.add(this.headers.get(name));
        }
        if (list.size() == 0 && name.startsWith("X-Atmosphere") && this.request.getAttribute(name) != null) {
            list.add(this.request.getAttribute(name));
        }
        return Collections.enumeration(list);
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList list = Collections.list(super.getHeaderNames());
        list.add("content-type");
        Enumeration e = this.request.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            if (!name.startsWith("X-Atmosphere")) continue;
            list.add(name);
        }
        for (String s : this.headers.keySet()) {
            list.add(s);
        }
        return Collections.enumeration(list);
    }

    public String getHeader(String s) {
        if (s.equalsIgnoreCase("Connection")) {
            return "keep-alive";
        }
        if ("content-type".equalsIgnoreCase(s)) {
            return this.contentType;
        }
        String name = super.getHeader(s);
        if (name == null) {
            if (this.headers.get(s) != null) {
                return this.headers.get(s);
            }
            if (s.startsWith("X-Atmosphere")) {
                return (String)this.request.getAttribute(s);
            }
        }
        return name;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.bis == null ? this.request.getInputStream() : this.bis;
    }

    public BufferedReader getReader() throws IOException {
        return this.br == null ? this.request.getReader() : this.br;
    }

    public static final class Builder {
        public HttpServletRequest request;
        public String pathInfo;
        public byte[] dataBytes;
        public int offset;
        public int length;
        public String encoding = "UTF-8";
        public String methodType;
        public String contentType;
        public String data;
        public Map<String, String> headers;

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder request(HttpServletRequest request) {
            this.request = request;
            return this;
        }

        public Builder pathInfo(String pathInfo) {
            this.pathInfo = pathInfo;
            return this;
        }

        public Builder body(byte[] dataBytes, int offset, int length) {
            this.dataBytes = dataBytes;
            this.offset = offset;
            this.length = length;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder method(String methodType) {
            this.methodType = methodType;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder body(String data) {
            this.data = data;
            return this;
        }

        public AtmosphereRequest build() {
            return new AtmosphereRequest(this);
        }
    }

    private static class ByteInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream bis;

        public ByteInputStream(byte[] data, int offset, int length) {
            this.bis = new ByteArrayInputStream(data, offset, length);
        }

        public int read() throws IOException {
            return this.bis.read();
        }
    }
}

