/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.Set;
import java.util.concurrent.Future;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBroadcaster
extends DefaultBroadcaster {
    private static final Logger logger = LoggerFactory.getLogger(SimpleBroadcaster.class);

    public SimpleBroadcaster(String id, AtmosphereServlet.AtmosphereConfig config) {
        super(id, config);
    }

    @Override
    public void setBroadcasterConfig(BroadcasterConfig bc) {
        this.bc = bc;
        bc.setExecutorService(null, false).setAsyncWriteService(null, false);
    }

    @Override
    public <T> Future<T> broadcast(T msg) {
        if (this.destroyed.get()) {
            logger.error("This Broadcaster has been destroyed and cannot be used");
            return null;
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        f.done();
        this.push(new DefaultBroadcaster.Entry(newMsg, null, f, msg));
        return f;
    }

    @Override
    public <T> Future<T> broadcast(T msg, AtmosphereResource<?, ?> r) {
        if (this.destroyed.get()) {
            logger.error("This Broadcaster has been destroyed and cannot be used");
            return null;
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        f.done();
        this.push(new DefaultBroadcaster.Entry(newMsg, r, f, msg));
        return f;
    }

    @Override
    public <T> Future<T> broadcast(T msg, Set<AtmosphereResource<?, ?>> subset) {
        if (this.destroyed.get()) {
            logger.error("This Broadcaster has been destroyed and cannot be used");
            return null;
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        f.done();
        this.push(new DefaultBroadcaster.Entry(newMsg, subset, f, msg));
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void queueWriteIO(AtmosphereResource<?, ?> r, Object finalMsg, DefaultBroadcaster.Entry entry) throws InterruptedException {
        AtmosphereResource<?, ?> atmosphereResource = r;
        synchronized (atmosphereResource) {
            this.executeAsyncWrite(r, finalMsg, entry.future);
        }
    }
}

