/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket.protocol;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketHttpServletResponse;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpProtocol
extends WebSocketProcessor
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereServlet.class);
    private final String contentType;
    private final String methodType;
    private final String delimiter;

    public SimpleHttpProtocol(AtmosphereServlet atmosphereServlet, WebSocket webSocket) {
        super(atmosphereServlet, webSocket);
        String contentType = atmosphereServlet.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.messageContentType");
        if (contentType == null) {
            contentType = "text/html";
        }
        this.contentType = contentType;
        String methodType = atmosphereServlet.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.messageMethod");
        if (methodType == null) {
            methodType = "POST";
        }
        this.methodType = methodType;
        String delimiter = atmosphereServlet.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.pathDelimiter");
        if (delimiter == null) {
            delimiter = "@@";
        }
        this.delimiter = delimiter;
    }

    @Override
    public void parseMessage(String d) {
        String pathInfo = this.request().getPathInfo();
        if (d.startsWith(this.delimiter)) {
            String[] token = d.split(this.delimiter);
            pathInfo = token[1];
            d = token[2];
        }
        AtmosphereRequest r = new AtmosphereRequest.Builder().request(this.request()).method(this.methodType).contentType(this.contentType).body(d).pathInfo(pathInfo).headers(this.configureHeader(this.request())).build();
        this.dispatch((HttpServletRequest)r, (HttpServletResponse)new WebSocketHttpServletResponse<WebSocket>(this.webSocketSupport()));
    }

    @Override
    public void parseMessage(byte[] d, int offset, int length) {
        try {
            String pathInfo = this.request().getPathInfo();
            if (d[0] == (byte)this.delimiter.charAt(0) && d[1] == (byte)this.delimiter.charAt(0)) {
                String s = new String(d, offset, length, "UTF-8");
                String[] token = s.split(this.delimiter);
                pathInfo = token[1];
                d = token[2].getBytes("UTF-8");
            }
            AtmosphereRequest r = new AtmosphereRequest.Builder().request(this.request()).method(this.methodType).contentType(this.contentType).body(d, offset, length).pathInfo(pathInfo).headers(this.configureHeader(this.request())).build();
            this.dispatch((HttpServletRequest)r, (HttpServletResponse)new WebSocketHttpServletResponse<WebSocket>(this.webSocketSupport()));
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }
}

