/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket.protocol;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpProtocol
implements WebSocketProtocol,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereServlet.class);
    private String contentType;
    private String methodType;
    private String delimiter;

    @Override
    public void configure(AtmosphereServlet.AtmosphereConfig config) {
        String contentType = config.getInitParameter("org.atmosphere.websocket.messageContentType");
        if (contentType == null) {
            contentType = "text/html";
        }
        this.contentType = contentType;
        String methodType = config.getInitParameter("org.atmosphere.websocket.messageMethod");
        if (methodType == null) {
            methodType = "POST";
        }
        this.methodType = methodType;
        String delimiter = config.getInitParameter("org.atmosphere.websocket.pathDelimiter");
        if (delimiter == null) {
            delimiter = "@@";
        }
        this.delimiter = delimiter;
    }

    @Override
    public HttpServletRequest parseMessage(AtmosphereResource<HttpServletRequest, HttpServletResponse> resource, String d) {
        String pathInfo = resource.getRequest().getPathInfo();
        if (d.startsWith(this.delimiter)) {
            String[] token = d.split(this.delimiter);
            pathInfo = token[1];
            d = token[2];
        }
        return new AtmosphereRequest.Builder().request(resource.getRequest()).method(this.methodType).contentType(this.contentType).body(d).pathInfo(pathInfo).headers(WebSocketProcessor.configureHeader(resource.getRequest())).build();
    }

    @Override
    public HttpServletRequest parseMessage(AtmosphereResource<HttpServletRequest, HttpServletResponse> resource, byte[] d, int offset, int length) {
        return this.parseMessage(resource, new String(d, offset, length));
    }
}

