/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import java.io.IOException;
import org.atmosphere.websocket.WebSocketAdapter;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocket
extends WebSocketAdapter {
    private static final Logger logger = LoggerFactory.getLogger(JettyWebSocket.class);
    private final WebSocket.Outbound outbound;
    private final byte frame = 0;

    public JettyWebSocket(WebSocket.Outbound outbound) {
        this.outbound = outbound;
    }

    @Override
    public void writeError(int errorCode, String message) throws IOException {
        logger.debug("{} {}", (Object)errorCode, (Object)message);
    }

    @Override
    public void redirect(String location) throws IOException {
        logger.error("redirect not supported");
    }

    @Override
    public void write(String data) throws IOException {
        if (!this.outbound.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        this.outbound.sendMessage((byte)0, data);
    }

    @Override
    public void write(byte[] data) throws IOException {
        if (!this.outbound.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        this.outbound.sendMessage((byte)0, data, 0, data.length);
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (!this.outbound.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        this.outbound.sendMessage((byte)0, data, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.outbound.disconnect();
    }
}

