/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AsyncProtocol;

public class AtmosphereResponse
extends HttpServletResponseWrapper {
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final Map<String, String> headers;
    private AsyncIOWriter asyncIOWriter;
    private int status = 200;
    private String statusMessage = "OK";
    private String charSet = "UTF-8";
    private long contentLength = -1L;
    private String contentType = "text/html";
    private boolean isCommited = false;
    private Locale locale;
    private AsyncProtocol asyncProtocol = new FakeAsyncProtocol();
    private boolean headerHandled = false;
    private HttpServletRequest atmosphereRequest;
    private static final DummyHttpServletResponse dsr = new DummyHttpServletResponse();
    private final AtomicBoolean writeStatusAndHeader = new AtomicBoolean(false);

    public AtmosphereResponse(AsyncIOWriter asyncIOWriter, AsyncProtocol asyncProtocol, HttpServletRequest atmosphereRequest) {
        super((HttpServletResponse)dsr);
        this.asyncIOWriter = asyncIOWriter;
        this.asyncProtocol = asyncProtocol;
        this.atmosphereRequest = atmosphereRequest;
        this.writeStatusAndHeader.set(false);
        this.headers = new HashMap<String, String>();
    }

    public AtmosphereResponse(HttpServletResponse r, AsyncIOWriter asyncIOWriter, AsyncProtocol asyncProtocol, HttpServletRequest atmosphereRequest) {
        super(r);
        this.asyncIOWriter = asyncIOWriter;
        this.asyncProtocol = asyncProtocol;
        this.atmosphereRequest = atmosphereRequest;
        this.writeStatusAndHeader.set(false);
        this.headers = new HashMap<String, String>();
    }

    private AtmosphereResponse(Builder b) {
        super((HttpServletResponse)dsr);
        this.asyncIOWriter = b.asyncIOWriter;
        this.asyncProtocol = b.asyncProtocol;
        this.atmosphereRequest = b.atmosphereRequest;
        this.status = b.status;
        this.statusMessage = b.statusMessage;
        this.writeStatusAndHeader.set(b.writeStatusAndHeader.get());
        this.headers = b.headers;
    }

    public void destroy() {
        this.cookies.clear();
        this.headers.clear();
        this.atmosphereRequest = null;
        this.asyncIOWriter = null;
        this.asyncProtocol = null;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public boolean containsHeader(String name) {
        return this.headers.get(name) != null;
    }

    public void sendError(int sc, String msg) throws IOException {
        this.setStatus(sc, msg);
        this.asyncIOWriter.writeError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.setStatus(sc);
        this.asyncIOWriter.writeError(sc, "");
    }

    public void sendRedirect(String location) throws IOException {
        this.asyncIOWriter.redirect(location);
    }

    public void setDateHeader(String name, long date) {
        this.headers.put(name, String.valueOf(date));
    }

    public void addDateHeader(String name, long date) {
        this.headers.put(name, String.valueOf(date));
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.put(name, String.valueOf(value));
    }

    public void addIntHeader(String name, int value) {
        this.headers.put(name, String.valueOf(value));
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(int status, String statusMessage) {
        this.statusMessage = statusMessage;
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Map<String, String> headers() {
        if (!this.headerHandled) {
            for (Cookie c : this.cookies) {
                this.headers.put("Set-Cookie", c.toString());
            }
            this.headerHandled = false;
        }
        return this.headers;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Collection<String> getHeaders(String name) {
        ArrayList<String> s = new ArrayList<String>();
        s.add(this.headers.get(name));
        return Collections.unmodifiableList(s);
    }

    public Collection<String> getHeaderNames() {
        return Collections.unmodifiableSet(this.headers.keySet());
    }

    public void setCharacterEncoding(String charset) {
        this.charSet = this.charSet;
    }

    public String getCharacterEncoding() {
        return this.charSet;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){

            public void write(int i) throws IOException {
                AtmosphereResponse.this.writeStatusAndHeaders();
                if (AtmosphereResponse.this.asyncProtocol.inspectResponse()) {
                    AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this.asyncProtocol.handleResponse(AtmosphereResponse.this, new byte[]{(byte)i}, 0, 1));
                } else {
                    AtmosphereResponse.this.asyncIOWriter.write(new byte[]{(byte)i});
                }
            }

            public void write(byte[] bytes) throws IOException {
                AtmosphereResponse.this.writeStatusAndHeaders();
                if (AtmosphereResponse.this.asyncProtocol.inspectResponse()) {
                    AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this.asyncProtocol.handleResponse(AtmosphereResponse.this, bytes, 0, bytes.length));
                } else {
                    AtmosphereResponse.this.asyncIOWriter.write(bytes);
                }
            }

            public void write(byte[] bytes, int start, int offset) throws IOException {
                AtmosphereResponse.this.writeStatusAndHeaders();
                if (AtmosphereResponse.this.asyncProtocol.inspectResponse()) {
                    byte[] b = AtmosphereResponse.this.asyncProtocol.handleResponse(AtmosphereResponse.this, bytes, start, offset);
                    AtmosphereResponse.this.asyncIOWriter.write(b, 0, b.length);
                } else {
                    AtmosphereResponse.this.asyncIOWriter.write(bytes, start, offset);
                }
            }

            public void flush() throws IOException {
                AtmosphereResponse.this.asyncIOWriter.flush();
            }

            public void close() throws IOException {
                AtmosphereResponse.this.asyncIOWriter.close();
            }
        };
    }

    private void writeStatusAndHeaders() throws IOException {
        if (this.writeStatusAndHeader.getAndSet(false)) {
            this.asyncIOWriter.write(this.constructStatusAndHeaders());
        }
    }

    private String constructStatusAndHeaders() {
        StringBuffer b = new StringBuffer("HTTP/1.1").append(" ").append(this.status).append(" ").append(this.statusMessage).append("\n");
        b.append("Content-Type").append(":").append(this.headers.get("Content-Type") == null ? this.contentType : this.headers.get("Content-Type")).append("\n");
        if (this.contentLength != -1L) {
            b.append("Content-Length").append(":").append(this.contentLength).append("\n");
        }
        for (String s : this.headers().keySet()) {
            if (s.equalsIgnoreCase("Content-Type")) continue;
            b.append(s).append(":").append(this.headers.get(s)).append("\n");
        }
        b.deleteCharAt(b.length() - 1);
        b.append("\r\n\r\n");
        return b.toString();
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter((OutputStream)this.getOutputStream()){

            @Override
            public void write(char[] chars, int offset, int lenght) {
                try {
                    AtmosphereResponse.this.writeStatusAndHeaders();
                    if (AtmosphereResponse.this.asyncProtocol.inspectResponse()) {
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this.asyncProtocol.handleResponse(AtmosphereResponse.this, new String(chars, offset, lenght)));
                    } else {
                        AtmosphereResponse.this.asyncIOWriter.write(new String(chars, offset, lenght));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void write(char[] chars) {
                try {
                    AtmosphereResponse.this.writeStatusAndHeaders();
                    if (AtmosphereResponse.this.asyncProtocol.inspectResponse()) {
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this.asyncProtocol.handleResponse(AtmosphereResponse.this, new String(chars)));
                    } else {
                        AtmosphereResponse.this.asyncIOWriter.write(new String(chars));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void write(String s, int offset, int lenght) {
                try {
                    AtmosphereResponse.this.writeStatusAndHeaders();
                    if (AtmosphereResponse.this.asyncProtocol.inspectResponse()) {
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this.asyncProtocol.handleResponse(AtmosphereResponse.this, new String(s.substring(offset, lenght))));
                    } else {
                        AtmosphereResponse.this.asyncIOWriter.write(new String(s.substring(offset, lenght)));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void write(String s) {
                try {
                    AtmosphereResponse.this.writeStatusAndHeaders();
                    if (AtmosphereResponse.this.asyncProtocol.inspectResponse()) {
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this.asyncProtocol.handleResponse(AtmosphereResponse.this, new String(s)));
                    } else {
                        AtmosphereResponse.this.asyncIOWriter.write(new String(s));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isCommitted() {
        return this.isCommited;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isWrapperFor(ServletResponse wrapped) {
        return false;
    }

    public boolean isWrapperFor(Class wrappedType) {
        return false;
    }

    public AsyncIOWriter getAsyncIOWriter() {
        return this.asyncIOWriter;
    }

    public HttpServletRequest getRequest() {
        return this.atmosphereRequest;
    }

    public void close() throws IOException {
        if (this.asyncIOWriter != null) {
            this.asyncIOWriter.close();
        }
    }

    private static final class FakeAsyncProtocol
    implements AsyncProtocol {
        private FakeAsyncProtocol() {
        }

        @Override
        public boolean inspectResponse() {
            return false;
        }

        @Override
        public String handleResponse(AtmosphereResponse res, String message) {
            return null;
        }

        @Override
        public byte[] handleResponse(AtmosphereResponse res, byte[] message, int offset, int length) {
            return new byte[0];
        }
    }

    private static final class DummyHttpServletResponse
    implements HttpServletResponse {
        private DummyHttpServletResponse() {
        }

        public void addCookie(Cookie cookie) {
        }

        public boolean containsHeader(String name) {
            return false;
        }

        public String encodeURL(String url) {
            return null;
        }

        public String encodeRedirectURL(String url) {
            return null;
        }

        public String encodeUrl(String url) {
            return null;
        }

        public String encodeRedirectUrl(String url) {
            return null;
        }

        public void sendError(int sc, String msg) throws IOException {
        }

        public void sendError(int sc) throws IOException {
        }

        public void sendRedirect(String location) throws IOException {
        }

        public void setDateHeader(String name, long date) {
        }

        public void addDateHeader(String name, long date) {
        }

        public void setHeader(String name, String value) {
        }

        public void addHeader(String name, String value) {
        }

        public void setIntHeader(String name, int value) {
        }

        public void addIntHeader(String name, int value) {
        }

        public void setStatus(int sc) {
        }

        public void setStatus(int sc, String sm) {
        }

        public int getStatus() {
            return 0;
        }

        public String getHeader(String name) {
            return null;
        }

        public Collection<String> getHeaders(String name) {
            return null;
        }

        public Collection<String> getHeaderNames() {
            return null;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return null;
        }

        public PrintWriter getWriter() throws IOException {
            return null;
        }

        public void setCharacterEncoding(String charset) {
        }

        public void setContentLength(int len) {
        }

        public void setContentType(String type) {
        }

        public void setBufferSize(int size) {
        }

        public int getBufferSize() {
            return 0;
        }

        public void flushBuffer() throws IOException {
        }

        public void resetBuffer() {
        }

        public boolean isCommitted() {
            return false;
        }

        public void reset() {
        }

        public void setLocale(Locale loc) {
        }

        public Locale getLocale() {
            return null;
        }
    }

    public static final class Builder {
        private AsyncIOWriter asyncIOWriter;
        private int status = 200;
        private String statusMessage = "OK";
        private AsyncProtocol asyncProtocol = new FakeAsyncProtocol();
        private HttpServletRequest atmosphereRequest;
        private AtomicBoolean writeStatusAndHeader = new AtomicBoolean(true);
        private final Map<String, String> headers = new HashMap<String, String>();

        public Builder asyncIOWriter(AsyncIOWriter asyncIOWriter) {
            this.asyncIOWriter = asyncIOWriter;
            return this;
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public Builder asyncProtocol(AsyncProtocol asyncProtocol) {
            this.asyncProtocol = asyncProtocol;
            return this;
        }

        public Builder atmosphereRequest(HttpServletRequest atmosphereRequest) {
            this.atmosphereRequest = atmosphereRequest;
            return this;
        }

        public AtmosphereResponse build() {
            return new AtmosphereResponse(this);
        }

        public Builder header(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder writeHeader(boolean writeStatusAndHeader) {
            this.writeStatusAndHeader.set(writeStatusAndHeader);
            return this;
        }
    }
}

