/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.atmosphere.config.ApplicationConfiguration;
import org.atmosphere.config.AtmosphereHandlerConfig;
import org.atmosphere.config.AtmosphereHandlerProperty;
import org.atmosphere.config.FrameworkConfiguration;
import org.atmosphere.container.BlockingIOCometSupport;
import org.atmosphere.container.Tomcat7Servlet30SupportWithWebSocket;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsyncSupportResolver;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.DefaultAsyncSupportResolver;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.DefaultBroadcasterFactory;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.di.InjectorProvider;
import org.atmosphere.di.ServletContextHolder;
import org.atmosphere.di.ServletContextProvider;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.interceptor.JSONPAtmosphereInterceptor;
import org.atmosphere.interceptor.SSEAtmosphereInterceptor;
import org.atmosphere.util.AtmosphereConfigReader;
import org.atmosphere.util.IntrospectionUtils;
import org.atmosphere.util.Version;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProtocol;
import org.atmosphere.websocket.protocol.SimpleHttpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereFramework
implements ServletContextProvider {
    public static final String DEFAULT_ATMOSPHERE_CONFIG_PATH = "/META-INF/atmosphere.xml";
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereFramework.class);
    protected final List<String> broadcasterFilters = new ArrayList<String>();
    protected final ArrayList<String> possibleComponentsCandidate = new ArrayList();
    protected final HashMap<String, String> initParams = new HashMap();
    protected final AtmosphereConfig config;
    protected final AtomicBoolean isCometSupportConfigured = new AtomicBoolean(false);
    protected final boolean isFilter;
    protected final Map<String, AtmosphereHandlerWrapper> atmosphereHandlers = new ConcurrentHashMap<String, AtmosphereHandlerWrapper>();
    protected final ConcurrentLinkedQueue<String> broadcasterTypes = new ConcurrentLinkedQueue();
    protected boolean useNativeImplementation = false;
    protected boolean useBlockingImplementation = false;
    protected boolean useStreamForFlushingComments = false;
    protected AsyncSupport asyncSupport;
    protected String broadcasterClassName = DefaultBroadcaster.class.getName();
    protected boolean isCometSupportSpecified = false;
    protected boolean isBroadcasterSpecified = false;
    protected boolean isSessionSupportSpecified = false;
    protected BroadcasterFactory broadcasterFactory;
    protected String broadcasterFactoryClassName;
    protected static String broadcasterCacheClassName;
    protected boolean webSocketEnabled = true;
    protected String broadcasterLifeCyclePolicy = "NEVER";
    protected String webSocketProtocolClassName = SimpleHttpProtocol.class.getName();
    protected WebSocketProtocol webSocketProtocol;
    protected String handlersPath = "/WEB-INF/classes/";
    protected ServletConfig servletConfig;
    protected boolean autoDetectHandlers = true;
    private boolean hasNewWebSocketProtocol = false;
    protected String atmosphereDotXmlPath = "/META-INF/atmosphere.xml";
    protected final LinkedList<AtmosphereInterceptor> interceptors = new LinkedList();
    protected boolean scanDone = false;

    @Override
    public ServletContext getServletContext() {
        return this.servletConfig.getServletContext();
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public List<String> broadcasterFilters() {
        return this.broadcasterFilters;
    }

    public AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    public AtmosphereFramework() {
        this(false, true);
    }

    public AtmosphereFramework(ServletConfig sc) throws ServletException {
        this(false, true);
        this.init(sc);
    }

    public AtmosphereFramework(boolean isFilter, boolean autoDetectHandlers) {
        this.isFilter = isFilter;
        this.autoDetectHandlers = autoDetectHandlers;
        this.readSystemProperties();
        this.populateBroadcasterType();
        this.config = new AtmosphereConfig(this);
    }

    private void populateBroadcasterType() {
        this.broadcasterTypes.add("org.atmosphere.plugin.hazelcast.HazelcastBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.xmpp.XMPPBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.redis.RedisBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.jgroups.JGroupsBroadcaster");
        this.broadcasterTypes.add("org.atmosphere.plugin.jms.JMSBroadcaster");
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(h, mapping);
        this.addMapping(mapping, w);
        logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)h.getClass().getName(), (Object)mapping);
        return this;
    }

    private AtmosphereFramework addMapping(String path, AtmosphereHandlerWrapper w) {
        if (path.contains("*")) {
            path = path.replace("*", "[/a-zA-Z0-9-&=;\\?]+");
        }
        this.atmosphereHandlers.put(path, w);
        return this;
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, String broadcasterId) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(h, mapping);
        w.broadcaster.setID(broadcasterId);
        this.addMapping(mapping, w);
        logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)h.getClass().getName(), (Object)mapping);
        return this;
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, Broadcaster broadcaster) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(h, broadcaster);
        this.addMapping(mapping, w);
        logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)h.getClass().getName(), (Object)mapping);
        return this;
    }

    public AtmosphereFramework removeAtmosphereHandler(String mapping) {
        this.atmosphereHandlers.remove(mapping);
        return this;
    }

    public AtmosphereFramework removeAllAtmosphereHandler() {
        this.atmosphereHandlers.clear();
        return this;
    }

    public AtmosphereFramework removeAllInitParams() {
        this.initParams.clear();
        return this;
    }

    public AtmosphereFramework addInitParameter(String name, String value) {
        this.initParams.put(name, value);
        return this;
    }

    protected void readSystemProperties() {
        if (System.getProperty("org.atmosphere.useNative") != null) {
            this.useNativeImplementation = Boolean.parseBoolean(System.getProperty("org.atmosphere.useNative"));
            this.isCometSupportSpecified = true;
        }
        if (System.getProperty("org.atmosphere.useBlocking") != null) {
            this.useBlockingImplementation = Boolean.parseBoolean(System.getProperty("org.atmosphere.useBlocking"));
            this.isCometSupportSpecified = true;
        }
        this.atmosphereDotXmlPath = System.getProperty("org.atmosphere.atmosphereDotXml", this.atmosphereDotXmlPath);
        if (System.getProperty("org.atmosphere.disableOnStateEvent") != null) {
            this.initParams.put("org.atmosphere.disableOnStateEvent", System.getProperty("org.atmosphere.disableOnStateEvent"));
        }
    }

    public void patchContainer() {
        System.setProperty("org.apache.catalina.STRICT_SERVLET_COMPLIANCE", "false");
    }

    public AtmosphereFramework init(final ServletConfig sc) throws ServletException {
        try {
            ServletConfig scFacade;
            ServletContextHolder.register(this);
            this.servletConfig = scFacade = new ServletConfig(){

                public String getServletName() {
                    return sc.getServletName();
                }

                public ServletContext getServletContext() {
                    return sc.getServletContext();
                }

                public String getInitParameter(String name) {
                    String param = sc.getInitParameter(name);
                    if (param == null) {
                        return AtmosphereFramework.this.initParams.get(name);
                    }
                    return param;
                }

                public Enumeration<String> getInitParameterNames() {
                    Enumeration en = sc.getInitParameterNames();
                    while (en.hasMoreElements()) {
                        String name = (String)en.nextElement();
                        if (AtmosphereFramework.this.initParams.containsKey(name)) continue;
                        AtmosphereFramework.this.initParams.put(name, name);
                    }
                    return Collections.enumeration(AtmosphereFramework.this.initParams.keySet());
                }
            };
            this.patchContainer();
            this.doInitParams(scFacade);
            this.doInitParamsForWebSocket(scFacade);
            this.configureBroadcaster(sc.getServletContext());
            this.loadConfiguration(scFacade);
            this.autoDetectContainer();
            this.configureWebDotXmlAtmosphereHandler(sc);
            this.initWebSocketProtocol();
            this.asyncSupport.init(scFacade);
            this.initAtmosphereHandler(scFacade);
            this.configureAtmosphereConfig(sc);
            if (broadcasterCacheClassName == null) {
                logger.warn("No BroadcasterCache configured. Broadcasted message between client reconnection will be LOST. It is recommended to configure the HeaderBroadcasterCache.");
            }
            logger.info("Using BroadcasterFactory class: {}", (Object)BroadcasterFactory.getDefault().getClass().getName());
            logger.info("Using Broadcaster class: {}", (Object)this.broadcasterClassName);
            logger.info("Atmosphere Framework {} started.", (Object)Version.getRawVersion());
        }
        catch (Throwable t) {
            logger.error("Failed to initialize Atmosphere Framework", t);
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
        return this;
    }

    protected void configureAtmosphereConfig(ServletConfig sc) {
        String s = sc.getInitParameter(ApplicationConfig.ATMOSPHERE_INTERCEPTORS);
        if (s != null) {
            String[] list;
            for (String a : list = s.split(",")) {
                try {
                    this.interceptors.add((AtmosphereInterceptor)Thread.currentThread().getContextClassLoader().loadClass(a.trim()).newInstance());
                }
                catch (InstantiationException e) {
                    logger.warn("", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    logger.warn("", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    logger.warn("", (Throwable)e);
                }
            }
        }
        this.interceptors.addLast(new SSEAtmosphereInterceptor());
        this.interceptors.addLast(new JSONPAtmosphereInterceptor());
        logger.info("Installed AtmosphereInterceptor {}", this.interceptors);
    }

    protected void configureWebDotXmlAtmosphereHandler(ServletConfig sc) {
        String s = sc.getInitParameter(ApplicationConfig.ATMOSPHERE_HANDLER);
        if (s != null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                String mapping = sc.getInitParameter(ApplicationConfig.ATMOSPHERE_HANDLER_MAPPING);
                if (mapping == null) {
                    mapping = "/*";
                }
                this.addAtmosphereHandler(mapping, (AtmosphereHandler)cl.loadClass(s).newInstance());
            }
            catch (Exception ex) {
                logger.warn("Unable to load WebSocketHandle instance", (Throwable)ex);
            }
        }
    }

    protected void configureBroadcaster(ServletContext sc) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.broadcasterFactoryClassName != null) {
            this.broadcasterFactory = (BroadcasterFactory)Thread.currentThread().getContextClassLoader().loadClass(this.broadcasterFactoryClassName).newInstance();
        }
        if (this.broadcasterFactory == null) {
            Class<?> bc = Thread.currentThread().getContextClassLoader().loadClass(this.broadcasterClassName);
            this.broadcasterFactory = new DefaultBroadcasterFactory(bc, this.broadcasterLifeCyclePolicy, this.config);
        }
        if (sc != null) {
            sc.setAttribute(BroadcasterFactory.class.getName(), (Object)this.broadcasterFactory);
        }
        BroadcasterFactory.setBroadcasterFactory(this.broadcasterFactory, this.config);
        InjectorProvider.getInjector().inject(this.broadcasterFactory);
        for (Map.Entry<String, AtmosphereHandlerWrapper> e : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandlerWrapper w = e.getValue();
            BroadcasterConfig broadcasterConfig = new BroadcasterConfig(this.broadcasterFilters, this.config);
            if (w.broadcaster == null) {
                w.broadcaster = this.broadcasterFactory.get(w.mapping);
                continue;
            }
            w.broadcaster.setBroadcasterConfig(broadcasterConfig);
            if (broadcasterCacheClassName == null) continue;
            BroadcasterCache cache = (BroadcasterCache)Thread.currentThread().getContextClassLoader().loadClass(broadcasterCacheClassName).newInstance();
            InjectorProvider.getInjector().inject(cache);
            broadcasterConfig.setBroadcasterCache(cache);
        }
    }

    protected void doInitParamsForWebSocket(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.useWebSocket");
        if (s != null) {
            this.webSocketEnabled = Boolean.parseBoolean(s);
            this.sessionSupport(false);
        }
        if ((s = sc.getInitParameter(ApplicationConfig.WEBSOCKET_PROTOCOL)) != null) {
            this.webSocketProtocolClassName = s;
        }
    }

    protected void doInitParams(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.useNative");
        if (s != null) {
            this.useNativeImplementation = Boolean.parseBoolean(s);
            if (this.useNativeImplementation) {
                this.isCometSupportSpecified = true;
            }
        }
        if ((s = sc.getInitParameter("org.atmosphere.useBlocking")) != null) {
            this.useBlockingImplementation = Boolean.parseBoolean(s);
            if (this.useBlockingImplementation) {
                this.isCometSupportSpecified = true;
            }
        }
        if ((s = sc.getInitParameter("org.atmosphere.useStream")) != null) {
            this.useStreamForFlushingComments = Boolean.parseBoolean(s);
        }
        if ((s = sc.getInitParameter(ApplicationConfig.PROPERTY_COMET_SUPPORT)) != null) {
            this.asyncSupport = new DefaultAsyncSupportResolver(this.config).newCometSupport(s);
            this.isCometSupportSpecified = true;
        }
        if ((s = sc.getInitParameter(ApplicationConfig.BROADCASTER_CLASS)) != null) {
            this.broadcasterClassName = s;
            this.isBroadcasterSpecified = true;
        }
        if ((s = sc.getInitParameter(ApplicationConfig.BROADCASTER_CACHE)) != null) {
            broadcasterCacheClassName = s;
        }
        if ((s = sc.getInitParameter(ApplicationConfig.PROPERTY_SESSION_SUPPORT)) != null) {
            this.config.setSupportSession(Boolean.valueOf(s));
            this.isSessionSupportSpecified = true;
        }
        if ((s = sc.getInitParameter("org.atmosphere.disableOnStateEvent")) != null) {
            this.initParams.put("org.atmosphere.disableOnStateEvent", s);
        } else {
            this.initParams.put("org.atmosphere.disableOnStateEvent", "false");
        }
        s = sc.getInitParameter("org.atmosphere.cpr.AtmosphereServlet.resumeAndKeepAlive");
        if (s != null) {
            this.initParams.put("org.atmosphere.cpr.AtmosphereServlet.resumeAndKeepAlive", s);
        }
        if ((s = sc.getInitParameter(ApplicationConfig.BROADCAST_FILTER_CLASSES)) != null) {
            this.broadcasterFilters.addAll(Arrays.asList(s.split(",")));
            logger.info("Installing BroadcastFilter class(es) {}", (Object)s);
        }
        if ((s = sc.getInitParameter(ApplicationConfig.BROADCASTER_LIFECYCLE_POLICY)) != null) {
            this.broadcasterLifeCyclePolicy = s;
        }
        if ((s = sc.getInitParameter(ApplicationConfig.BROADCASTER_FACTORY)) != null) {
            this.broadcasterFactoryClassName = s;
        }
        if ((s = sc.getInitParameter(ApplicationConfig.ATMOSPHERE_HANDLER_PATH)) != null) {
            this.handlersPath = s;
        }
    }

    public void loadConfiguration(ServletConfig sc) throws ServletException {
        if (!this.autoDetectHandlers) {
            return;
        }
        try {
            URL url = sc.getServletContext().getResource(this.handlersPath);
            URLClassLoader urlC = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
            this.loadAtmosphereDotXml(sc.getServletContext().getResourceAsStream(this.atmosphereDotXmlPath), urlC);
            if (this.atmosphereHandlers.size() == 0) {
                this.autoDetectAtmosphereHandlers(sc.getServletContext(), urlC);
                if (this.atmosphereHandlers.size() == 0) {
                    this.detectSupportedFramework(sc);
                }
            }
            this.autoDetectWebSocketHandler(sc.getServletContext(), urlC);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    protected boolean detectSupportedFramework(ServletConfig sc) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String broadcasterClassNameTmp = null;
        try {
            cl.loadClass("com.sun.jersey.spi.container.servlet.ServletContainer");
            if (!this.isBroadcasterSpecified) {
                broadcasterClassNameTmp = this.lookupDefaultBroadcasterType();
                cl.loadClass(broadcasterClassNameTmp);
            }
            this.useStreamForFlushingComments = true;
        }
        catch (Throwable t) {
            logger.trace("", t);
            return false;
        }
        logger.warn("Missing META-INF/atmosphere.xml but found the Jersey runtime. Starting Jersey");
        this.initParams.put(FrameworkConfig.WRITE_HEADERS, "false");
        ReflectorServletProcessor rsp = new ReflectorServletProcessor();
        if (broadcasterClassNameTmp != null) {
            this.broadcasterClassName = broadcasterClassNameTmp;
        }
        rsp.setServletClassName("com.sun.jersey.spi.container.servlet.ServletContainer");
        this.sessionSupport(false);
        this.initParams.put("org.atmosphere.disableOnStateEvent", "true");
        String mapping = sc.getInitParameter("org.atmosphere.jersey.servlet-mapping");
        if (mapping == null) {
            mapping = "/*";
        }
        Class<?> bc = cl.loadClass(this.broadcasterClassName);
        this.broadcasterFactory.destroy();
        this.broadcasterFactory = new DefaultBroadcasterFactory(bc, this.broadcasterLifeCyclePolicy, this.config);
        Broadcaster b = BroadcasterFactory.getDefault().get(bc, mapping);
        this.addAtmosphereHandler(mapping, (AtmosphereHandler)rsp, b);
        return true;
    }

    protected String lookupDefaultBroadcasterType() {
        for (String b : this.broadcasterTypes) {
            try {
                Class.forName(b);
                return b;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return "org.atmosphere.jersey.JerseyBroadcaster";
    }

    protected void sessionSupport(boolean sessionSupport) {
        if (!this.isSessionSupportSpecified) {
            this.config.setSupportSession(sessionSupport);
        }
    }

    void initAtmosphereHandler(ServletConfig sc) throws ServletException {
        for (Map.Entry<String, AtmosphereHandlerWrapper> h : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandlerWrapper w = h.getValue();
            AtmosphereHandler a = w.atmosphereHandler;
            if (!(a instanceof AtmosphereServletProcessor)) continue;
            ((AtmosphereServletProcessor)a).init(sc);
        }
        if (this.atmosphereHandlers.size() == 0 && !SimpleHttpProtocol.class.isAssignableFrom(this.webSocketProtocol.getClass())) {
            logger.debug("Adding a void AtmosphereHandler mapped to /* to allow WebSocket application only");
            this.addAtmosphereHandler("/*", new AbstractReflectorAtmosphereHandler(){

                @Override
                public void onRequest(AtmosphereResource httpServletRequestHttpServletResponseAtmosphereResource) throws IOException {
                }

                @Override
                public void destroy() {
                }
            });
        }
    }

    protected void initWebSocketProtocol() {
        if (this.webSocketProtocol == null) {
            try {
                this.webSocketProtocol = (WebSocketProtocol)AtmosphereFramework.class.getClassLoader().loadClass(this.webSocketProtocolClassName).newInstance();
                logger.info("Installed WebSocketProtocol {} ", (Object)this.webSocketProtocolClassName);
            }
            catch (Exception ex) {
                logger.error("Cannot load the WebSocketProtocol {}", (Object)this.getWebSocketProtocolClassName(), (Object)ex);
                this.webSocketProtocol = new SimpleHttpProtocol();
            }
        }
        this.webSocketProtocol.configure(this.config);
    }

    public AtmosphereFramework destroy() {
        if (this.asyncSupport != null && AsynchronousProcessor.class.isAssignableFrom(this.asyncSupport.getClass())) {
            ((AsynchronousProcessor)this.asyncSupport).shutdown();
        }
        Object bc = null;
        for (Map.Entry<String, AtmosphereHandlerWrapper> entry : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandlerWrapper handlerWrapper = entry.getValue();
            handlerWrapper.atmosphereHandler.destroy();
        }
        BroadcasterFactory factory = BroadcasterFactory.getDefault();
        if (factory != null) {
            factory.destroy();
            BroadcasterFactory.factory = null;
        }
        return this;
    }

    protected void loadAtmosphereDotXml(InputStream stream, URLClassLoader c) throws IOException, ServletException {
        if (stream == null) {
            return;
        }
        AtmosphereConfigReader.getInstance().parse(this.config, stream);
        for (AtmosphereHandlerConfig atmoHandler : this.config.getAtmosphereHandler()) {
            try {
                Object bc;
                String string;
                AtmosphereHandler handler;
                if (!ReflectorServletProcessor.class.getName().equals(atmoHandler.getClassName())) {
                    handler = (AtmosphereHandler)c.loadClass(atmoHandler.getClassName()).newInstance();
                    InjectorProvider.getInjector().inject(handler);
                } else {
                    handler = new ReflectorServletProcessor();
                }
                logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)handler, (Object)atmoHandler.getContextRoot());
                for (ApplicationConfiguration applicationConfiguration : atmoHandler.getApplicationConfig()) {
                    this.initParams.put(applicationConfiguration.getParamName(), applicationConfiguration.getParamValue());
                }
                for (FrameworkConfiguration frameworkConfiguration : atmoHandler.getFrameworkConfig()) {
                    this.initParams.put(frameworkConfiguration.getParamName(), frameworkConfiguration.getParamValue());
                }
                boolean isJersey = false;
                for (AtmosphereHandlerProperty handlerProperty : atmoHandler.getProperties()) {
                    if (handlerProperty.getValue() != null && handlerProperty.getValue().indexOf("jersey") != -1) {
                        isJersey = true;
                        this.initParams.put("org.atmosphere.disableOnStateEvent", "true");
                        this.useStreamForFlushingComments = true;
                        this.broadcasterClassName = this.lookupDefaultBroadcasterType();
                        this.broadcasterFactory = null;
                        this.configureBroadcaster(this.servletConfig.getServletContext());
                    }
                    IntrospectionUtils.setProperty(handler, handlerProperty.getName(), handlerProperty.getValue());
                    IntrospectionUtils.addProperty(handler, handlerProperty.getName(), handlerProperty.getValue());
                }
                this.config.setSupportSession(!isJersey);
                if (!atmoHandler.getSupportSession().equals("")) {
                    this.sessionSupport(Boolean.valueOf(atmoHandler.getSupportSession()));
                }
                if ((string = atmoHandler.getBroadcaster()) != null) {
                    this.broadcasterClassName = string;
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    bc = cl.loadClass(this.broadcasterClassName);
                    this.broadcasterFactory = new DefaultBroadcasterFactory((Class<? extends Broadcaster>)bc, this.broadcasterLifeCyclePolicy, this.config);
                    BroadcasterFactory.setBroadcasterFactory(this.broadcasterFactory, this.config);
                }
                Broadcaster b = BroadcasterFactory.getDefault().get(atmoHandler.getContextRoot());
                AtmosphereHandlerWrapper wrapper = new AtmosphereHandlerWrapper(handler, b);
                this.addMapping(atmoHandler.getContextRoot(), wrapper);
                bc = atmoHandler.getBroadcasterCache();
                if (bc != null) {
                    broadcasterCacheClassName = bc;
                }
                if (atmoHandler.getCometSupport() != null) {
                    this.asyncSupport = (AsyncSupport)c.loadClass(atmoHandler.getCometSupport()).getDeclaredConstructor(AtmosphereConfig.class).newInstance(this.config);
                }
                if (atmoHandler.getBroadcastFilterClasses() == null) continue;
                this.broadcasterFilters.addAll(atmoHandler.getBroadcastFilterClasses());
            }
            catch (Throwable t) {
                logger.warn("unable to load AtmosphereHandler class: " + atmoHandler.getClassName(), t);
                throw new ServletException(t);
            }
        }
    }

    public AtmosphereFramework setAsyncSupport(AsyncSupport asyncSupport) {
        this.asyncSupport = asyncSupport;
        return this;
    }

    public AtmosphereFramework setCometSupport(AsyncSupport asyncSupport) {
        return this.setAsyncSupport(asyncSupport);
    }

    public AsyncSupport getAsyncSupport() {
        return this.asyncSupport;
    }

    public AsyncSupport getCometSupport() {
        return this.asyncSupport;
    }

    protected AsyncSupportResolver createAsyncSupportResolver() {
        return new DefaultAsyncSupportResolver(this.config);
    }

    protected void autoDetectContainer() {
        if (this.getAsyncSupport() == null) {
            this.setAsyncSupport(this.createAsyncSupportResolver().resolve(this.useNativeImplementation, this.useBlockingImplementation, this.webSocketEnabled));
        }
        logger.info("Atmosphere is using async support: {} running under container: {}", (Object)this.getAsyncSupport().getClass().getName(), (Object)this.asyncSupport.getContainerName());
    }

    public void autoDetectAtmosphereHandlers(ServletContext servletContext, URLClassLoader classloader) throws MalformedURLException, URISyntaxException {
        if (this.atmosphereHandlers.size() > 0) {
            return;
        }
        logger.info("Auto detecting atmosphere handlers {}", (Object)this.handlersPath);
        String realPath = servletContext.getRealPath(this.handlersPath);
        if (realPath == null) {
            URL u = servletContext.getResource(this.handlersPath);
            if (u == null) {
                return;
            }
            realPath = u.getPath();
        }
        this.loadAtmosphereHandlersFromPath(classloader, realPath);
    }

    public void loadAtmosphereHandlersFromPath(URLClassLoader classloader, String realPath) {
        File file = new File(realPath);
        if (file.isDirectory()) {
            this.getFiles(file);
            this.scanDone = true;
            for (String className : this.possibleComponentsCandidate) {
                try {
                    className = className.replace('\\', '/');
                    Class<?> clazz = classloader.loadClass(className = className.replaceFirst("^.*/(WEB-INF|target)/(test-)?classes/(.*)\\.class", "$3").replace("/", "."));
                    if (!AtmosphereHandler.class.isAssignableFrom(clazz)) continue;
                    AtmosphereHandler handler = (AtmosphereHandler)clazz.newInstance();
                    InjectorProvider.getInjector().inject(handler);
                    this.addMapping("/" + handler.getClass().getSimpleName(), new AtmosphereHandlerWrapper(handler, "/" + handler.getClass().getSimpleName()));
                    logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)handler, (Object)handler.getClass().getName());
                }
                catch (Throwable t) {
                    logger.trace("failed to load class as an AtmosphereHandler: " + className, t);
                }
            }
        }
    }

    protected void autoDetectWebSocketHandler(ServletContext servletContext, URLClassLoader classloader) throws MalformedURLException, URISyntaxException {
        if (this.hasNewWebSocketProtocol) {
            return;
        }
        logger.info("Auto detecting WebSocketHandler in {}", (Object)this.handlersPath);
        String realPath = servletContext.getRealPath(this.handlersPath);
        if (realPath == null) {
            URL u = servletContext.getResource(this.handlersPath);
            if (u == null) {
                return;
            }
            realPath = u.getPath();
        }
        this.loadWebSocketFromPath(classloader, realPath);
    }

    protected void loadWebSocketFromPath(URLClassLoader classloader, String realPath) {
        File file = new File(realPath);
        if (file.isDirectory()) {
            this.getFiles(file);
            this.scanDone = true;
            for (String className : this.possibleComponentsCandidate) {
                try {
                    className = className.replace('\\', '/');
                    Class<?> clazz = classloader.loadClass(className = className.replaceFirst("^.*/(WEB-INF|target)/(test-)?classes/(.*)\\.class", "$3").replace("/", "."));
                    if (!WebSocketProtocol.class.isAssignableFrom(clazz)) continue;
                    this.webSocketProtocol = (WebSocketProtocol)clazz.newInstance();
                    InjectorProvider.getInjector().inject(this.webSocketProtocol);
                    logger.info("Installed WebSocketProtocol {}", (Object)this.webSocketProtocol);
                }
                catch (Throwable t) {
                    logger.trace("failed to load class as an WebSocketProtocol: " + className, t);
                }
            }
        }
    }

    private void getFiles(File f) {
        File[] files;
        if (this.scanDone) {
            return;
        }
        for (File test : files = f.listFiles()) {
            if (test.isDirectory()) {
                this.getFiles(test);
                continue;
            }
            String clazz = test.getAbsolutePath();
            if (!clazz.endsWith(".class")) continue;
            this.possibleComponentsCandidate.add(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action doCometSupport(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        block13: {
            req.setAttribute(ApplicationConfig.BROADCASTER_FACTORY, this.broadcasterFactory);
            req.setAttribute("org.atmosphere.useStream", this.useStreamForFlushingComments);
            req.setAttribute(ApplicationConfig.BROADCASTER_CLASS, this.broadcasterClassName);
            req.setAttribute(FrameworkConfig.ATMOSPHERE_CONFIG, this.config);
            if (res.request() == null) {
                res.request(req);
            }
            Action a = null;
            try {
                boolean skip = true;
                String s = this.config.getInitParameter(ApplicationConfig.ALLOW_QUERYSTRING_AS_REQUEST);
                if (s != null) {
                    skip = Boolean.valueOf(s);
                }
                if (!skip || req.getAttribute(WebSocket.WEBSOCKET_SUSPEND) == null) {
                    Map<String, String> headers = this.configureQueryStringAsRequest(req);
                    String body = headers.remove("X-Atmosphere-Post-Body");
                    if (body != null && body.isEmpty()) {
                        body = null;
                    }
                    req.headers(headers).method(body != null && req.getMethod().equalsIgnoreCase("GET") ? "POST" : req.getMethod());
                    if (body != null) {
                        req.body(body);
                    }
                }
                a = this.asyncSupport.service(req, res);
            }
            catch (IllegalStateException ex) {
                if (ex.getMessage() != null && (ex.getMessage().startsWith("Tomcat failed") || ex.getMessage().startsWith("JBoss failed"))) {
                    if (!this.isFilter) {
                        logger.warn("Failed using comet support: {}, error: {} Is the Nio or Apr Connector enabled?", (Object)this.asyncSupport.getClass().getName(), (Object)ex.getMessage());
                    }
                    logger.trace(ex.getMessage(), (Throwable)ex);
                    this.asyncSupport = this.asyncSupport.supportWebSocket() ? new Tomcat7Servlet30SupportWithWebSocket(this.config) : new BlockingIOCometSupport(this.config);
                    logger.warn("Using " + this.asyncSupport.getClass().getName());
                    a = this.doCometSupport(req, res);
                    break block13;
                }
                logger.error("AtmosphereFramework exception", (Throwable)ex);
                throw ex;
            }
            finally {
                if (req != null && a != null && a.type() != Action.TYPE.SUSPEND) {
                    req.destroy();
                    res.destroy();
                }
            }
        }
        return null;
    }

    public String getDefaultBroadcasterClassName() {
        return this.broadcasterClassName;
    }

    public AtmosphereFramework setDefaultBroadcasterClassName(String bccn) {
        this.broadcasterClassName = bccn;
        return this;
    }

    public boolean isUseStreamForFlushingComments() {
        return this.useStreamForFlushingComments;
    }

    public AtmosphereFramework setUseStreamForFlushingComments(boolean useStreamForFlushingComments) {
        this.useStreamForFlushingComments = useStreamForFlushingComments;
        return this;
    }

    public BroadcasterFactory getBroadcasterFactory() {
        return this.broadcasterFactory;
    }

    public AtmosphereFramework setBroadcasterFactory(BroadcasterFactory broadcasterFactory) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this.broadcasterFactory = broadcasterFactory;
        this.configureBroadcaster(this.config.getServletContext());
        return this;
    }

    public String getBroadcasterCacheClassName() {
        return broadcasterCacheClassName;
    }

    public void setBroadcasterCacheClassName(String broadcasterCacheClassName) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        AtmosphereFramework.broadcasterCacheClassName = broadcasterCacheClassName;
        this.configureBroadcaster(this.config.getServletContext());
    }

    public AtmosphereFramework addBroadcasterType(String broadcasterTypeString) {
        this.broadcasterTypes.add(broadcasterTypeString);
        return this;
    }

    public String getWebSocketProtocolClassName() {
        return this.webSocketProtocolClassName;
    }

    public AtmosphereFramework setWebSocketProtocolClassName(String webSocketProtocolClassName) {
        this.hasNewWebSocketProtocol = true;
        this.webSocketProtocolClassName = webSocketProtocolClassName;
        return this;
    }

    public Map<String, AtmosphereHandlerWrapper> getAtmosphereHandlers() {
        return this.atmosphereHandlers;
    }

    protected Map<String, String> configureQueryStringAsRequest(AtmosphereRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration<String> e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            headers.put(s, request.getParameter(s));
        }
        return headers;
    }

    protected boolean isIECandidate(AtmosphereRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null) {
            return false;
        }
        if (userAgent.contains("MSIE") || userAgent.contains(".NET")) {
            String transport = request.getHeader("X-Atmosphere-Transport");
            return transport == null;
        }
        return false;
    }

    public WebSocketProtocol getWebSocketProtocol() {
        return this.webSocketProtocol;
    }

    public boolean isUseNativeImplementation() {
        return this.useNativeImplementation;
    }

    public AtmosphereFramework setUseNativeImplementation(boolean useNativeImplementation) {
        this.useNativeImplementation = useNativeImplementation;
        return this;
    }

    public boolean isUseBlockingImplementation() {
        return this.useBlockingImplementation;
    }

    public AtmosphereFramework setUseBlockingImplementation(boolean useBlockingImplementation) {
        this.useBlockingImplementation = useBlockingImplementation;
        return this;
    }

    public String getAtmosphereDotXmlPath() {
        return this.atmosphereDotXmlPath;
    }

    public AtmosphereFramework setAtmosphereDotXmlPath(String atmosphereDotXmlPath) {
        this.atmosphereDotXmlPath = atmosphereDotXmlPath;
        return this;
    }

    public String getHandlersPath() {
        return this.handlersPath;
    }

    public AtmosphereFramework setHandlersPath(String handlersPath) {
        this.handlersPath = handlersPath;
        return this;
    }

    public AtmosphereFramework interceptor(AtmosphereInterceptor c) {
        this.interceptors.addLast(c);
        return this;
    }

    public LinkedList<AtmosphereInterceptor> interceptors() {
        return this.interceptors;
    }

    public static final class AtmosphereHandlerWrapper {
        public final AtmosphereHandler atmosphereHandler;
        public Broadcaster broadcaster;
        public String mapping;

        public AtmosphereHandlerWrapper(AtmosphereHandler atmosphereHandler, String mapping) {
            this.atmosphereHandler = atmosphereHandler;
            try {
                if (BroadcasterFactory.getDefault() != null) {
                    this.broadcaster = BroadcasterFactory.getDefault().get(mapping);
                } else {
                    this.mapping = mapping;
                }
            }
            catch (Exception t) {
                throw new RuntimeException(t);
            }
        }

        public AtmosphereHandlerWrapper(AtmosphereHandler atmosphereHandler, Broadcaster broadcaster) {
            this.atmosphereHandler = atmosphereHandler;
            this.broadcaster = broadcaster;
        }

        public String toString() {
            return "AtmosphereHandlerWrapper{ atmosphereHandler=" + this.atmosphereHandler + ", broadcaster=" + this.broadcaster + " }";
        }
    }
}

